<?php
if (!defined('ABSPATH')) exit;

function aialttext_token_account_page(){
    if ( ! aialttext_token_user_can( 'account' ) ) {
        return;
    }
        
    $email       = get_option( 'aialttext_token_account_email', get_option( 'admin_email' ) );
    $access_key  = get_option( 'aialttext_token_access_key', '' );
    $masked_key  = $access_key ? substr( $access_key, 0, 6 ) . '••••••' . substr( $access_key, -4 ) : '—';
    $show_success = ( ! empty( $_GET['payment'] ) && $_GET['payment'] === 'success' && ! empty( $_GET['session_id'] ) );
        
    // Auto-generate status + Settings URL for account page notice
    $auto_generate = (int) get_option( 'aialttext_token_auto_generate', 0 );
    $settings_url  = admin_url( 'admin.php?page=aialttext-token-settings' );

    // Access level: only "full" should see token balance, access key, and auto-generate notice
    $access_level = function_exists( 'aialttext_token_get_user_access_level' )
        ? aialttext_token_get_user_access_level()
        : 'full';

    $has_full_access = ( $access_level === 'full' );

    // Treat "logged in to IMG Alt Gen" as having an access key
    $is_linked       = ! empty( $access_key );
    $show_sensitive  = ( $has_full_access && $is_linked );
        
    ?>
    <div class="wrap aialttext-token-wrap">

    <h1><?php echo esc_html__('AI Alt Text Generator – Account & Tokens', 'aialttext-token'); ?></h1>
    <?php if ( ! empty($_GET['loggedout']) ) : ?>
    <div class="notice notice-success is-dismissible">
        <p><?php esc_html_e('You have been logged out on this site.', 'aialttext-token'); ?></p>
    </div>
<?php endif; ?>
        <?php /* JS will handle the purchase popup; removed server-side banner to avoid duplicates. */ ?>
        
        <div class="aialttext-section-stack aialttext-dark">
            <div class="aialttext-token-card">
            <h2><?php esc_html_e('Account', 'aialttext-token'); ?></h2>
            <?php
$is_linked       = ! empty($access_key);
$email_attr      = $is_linked ? 'readonly="readonly" disabled="disabled"' : '';
$link_btn_style  = $is_linked ? 'display:none' : '';
$logout_btn_style= $is_linked ? '' : 'display:none';
?>
<?php if ($is_linked): ?>
    <div class="notice notice-success is-dismissible">
    <p>
  <strong><?php echo esc_html__('Account linked.', 'aialttext-token'); ?></strong>
  <?php echo esc_html__('Your site is connected to IMG Alt Gen Pro and ready to use.', 'aialttext-token'); ?>
</p>
    </div>
<?php endif; ?>
<?php
$is_linked       = ! empty($access_key);
$email_attr      = $is_linked ? 'readonly="readonly" disabled="disabled"' : '';
$link_btn_style  = $is_linked ? 'display:none' : '';
$logout_btn_style= $is_linked ? '' : 'display:none';
?>
<?php if (!$is_linked): ?>
    <p>
  <strong><?php echo esc_html__('Welcome!', 'aialttext-token'); ?></strong>
  <?php echo wp_kses_post(
    sprintf(
      /* translators: 1: UI label for link button, 2: number of free tokens */
      __('Enter your email and click <em>%1$s</em> to connect your account and instantly claim your free <strong>%2$d tokens</strong>.', 'aialttext-token'),
      esc_html__('Link / Relink', 'aialttext-token'),
      10
    )
  ); ?>
</p>
<?php endif; ?>
<table class="form-table">
    <tr>
        <th><?php esc_html_e( 'Email', 'aialttext-token' ); ?></th>
        <td>
            <input
                type="email"
                id="aialttext_token_account_email"
                value="<?php echo esc_attr( $email ); ?>"
                class="regular-text"
                <?php echo $email_attr; ?>
            />

            <button
                id="aialttext_token_link_account_btn"
                class="button button-primary<?php echo $is_linked ? '' : ' aialttext-onboard-pulse'; ?>"
                style="<?php echo $link_btn_style; ?>"
            >
                <?php esc_html_e( 'Sign-up / Log in', 'aialttext-token' ); ?>
            </button>

            <a
                id="aialttext_token_logout_btn"
                class="button button-secondary"
                style="<?php echo $logout_btn_style; ?>"
                href="<?php echo esc_url(
                    wp_nonce_url(
                        admin_url( 'admin-post.php?action=aialttext_token_logout_account' ),
                        'aialttext_token_nonce',
                        'nonce'
                    )
                ); ?>"
            >
                <?php esc_html_e( 'Log out', 'aialttext-token' ); ?>
            </a>

            <?php if ( ! $is_linked ) : ?>
                <p id="aialttext-onboard-tip" class="description aialttext-onboard-tip">
                    <?php
                    echo wp_kses_post(
                        sprintf(
                            /* translators: %s is the number of free tokens */
                            __(
                                'First time here? Enter your email above and click <em>Sign-Up / Log in</em> to connect your account and instantly claim your free <strong>%s tokens</strong>. Calls to our service can only happen with a linked account',
                                'aialttext-token'
                            ),
                            10
                        )
                    );
                    ?>
                </p>
            <?php endif; ?>
        </td>
    </tr>

    <tr <?php echo $is_linked ? 'style="display:none"' : ''; ?>>
        <th><?php esc_html_e( 'Password', 'aialttext-token' ); ?></th>
        <td>
            <input
                type="password"
                id="aialttext_token_account_password"
                class="regular-text"
                autocomplete="new-password"
                pattern="(?=.*[A-Z])(?=.*\d)(?=.*[^A-Za-z0-9]).{8,}"
            />
            <p class="description">
                <?php esc_html_e(
                    'Password must include: ≥8 chars, 1 uppercase, 1 number, 1 special character. Your password is used to log into your account; never stored locally.',
                    'aialttext-token'
                ); ?>
            </p>
            <ul id="aialttext-password-meter" style="margin:4px 0 0 18px;">
                <li data-req="len">
                    <?php esc_html_e( '≥ 8 characters', 'aialttext-token' ); ?>
                </li>
                <li data-req="upper">
                    <?php esc_html_e( '1 uppercase letter', 'aialttext-token' ); ?>
                </li>
                <li data-req="num">
                    <?php esc_html_e( '1 number', 'aialttext-token' ); ?>
                </li>
                <li data-req="special">
                    <?php esc_html_e( '1 special character', 'aialttext-token' ); ?>
                </li>
            </ul>
        </td>
    </tr>

    <tr <?php echo $is_linked ? 'style="display:none"' : ''; ?>>
        <th><?php esc_html_e( 'Consent', 'aialttext-token' ); ?></th>
        <td>
            <label for="aialttext_token_consent" style="display:block; line-height:1.6;">
                <input type="checkbox" id="aialttext_token_consent" />
                <?php
                echo wp_kses_post(
                    sprintf(
                        /* translators: 1: Terms URL, 2: Privacy URL */
                        __(
                            'By signing up or logging into your account you agree to our <a href="%1$s" target="_blank" rel="noopener">Terms</a> and <a href="%2$s" target="_blank" rel="noopener">Privacy Policy</a>.',
                            'aialttext-token'
                        ),
                        esc_url( 'https://imgaltgen.com/terms' ),
                        esc_url( 'https://imgaltgen.com/privacy' )
                    )
                );
                ?>
            </label>
            <p class="description">
                <?php esc_html_e(
                    'Required to connect this site to your IMG Alt Gen account.',
                    'aialttext-token'
                ); ?>
            </p>
        </td>
    </tr>

    <tr>
    <?php if ( $show_sensitive ) : ?>
    <tr>
        <th><?php esc_html_e( 'Token Balance', 'aialttext-token' ); ?></th>
        <td>
            <span id="aialttext-token-balance">
                <?php echo esc_html( (string) aialttext_token_check_balance() ); ?>
            </span>
            <a href="#" id="aialttext_token_refresh_balance">
                <?php esc_html_e( 'Refresh', 'aialttext-token' ); ?>
            </a>
        </td>
    </tr>

    <tr>
        <th><?php esc_html_e( 'Access Key', 'aialttext-token' ); ?></th>
        <td>
            <code><?php echo esc_html( $masked_key ); ?></code>
        </td>
    </tr>
    <?php endif; ?>


        <tr>
        <th><?php esc_html_e( 'Account management', 'aialttext-token' ); ?></th>
        <td>
            <p class="description">
                <?php
                esc_html_e(
                    'To change your email address, unlink sites, or manage billing and invoices, please use the account dashboard available in your IMG Alt Gen dashboard on our main product site.',
                    'aialttext-token'
                );
                ?>
                <br />
                <a href="https://www.imgaltgen.com/account" target="_blank" rel="noopener">
                    <?php esc_html_e( 'Open IMG Alt Gen account dashboard', 'aialttext-token' ); ?>
                </a>
            </p>

            <?php if ( $show_sensitive ) : ?>
            <p class="auto_gen_description">
                <?php if ( $auto_generate === 1 ) : ?>
                    <strong style="color:#11ff05; background=#0f172a; padding:5px; border-radius:5px; margin-bottom: 10px;">
                        <?php esc_html_e(
                            'Auto Generate upon upload is ON.',
                            'aialttext-token'
                        ); ?>
                    </strong>
                <?php else : ?>
                    <strong style="color:#ff3d43; background=#0f172a; padding:5px; border-radius:5px; margin-bottom: 10px;"">
                        <?php esc_html_e(
                            'Auto Generate upon upload is OFF.',
                            'aialttext-token'
                        ); ?>
                    </strong>
                <?php endif; ?>
                <br />
                <?php
                printf(
                    '<a href="%s">%s</a>',
                    esc_url( $settings_url ),
                    esc_html__( 'You can change this on the settings page.', 'aialttext-token' )
                );
                ?>
            </p>
            <?php endif; ?>
        </td>
    </tr>
    </table>

</div>

<?php if ( ! empty( $access_key ) ) : ?>
<div class="aialttext-token-card">
<h2><?php esc_html_e('Purchase More Tokens - 1 Token Per Image', 'aialttext-token'); ?></h2>
    <div id="aialttext_token_pricing" class="aialttext-token-pricing"></div>
</div>
<?php endif; ?>

        </div>

        </div>
    </div>
    <?php
}

function aialttext_token_register_account(){
    aialttext_token_check_nonce();
    if ( ! aialttext_token_user_can('account') ) {
        wp_send_json_error(array('message' => __('Insufficient privileges', 'aialttext-token')), 403);
    }

    $email    = sanitize_email($_POST['email'] ?? '');
    $password = isset($_POST['password']) ? (string) wp_unslash($_POST['password']) : '';
    $consent_raw = $_POST['consent'] ?? null;
$consent     = 0;
if (is_string($consent_raw)) {
    $cr = strtolower(trim((string) $consent_raw));
    $consent = (int) ($cr === '1' || $cr === 'true' || $cr === 'on' || $cr === 'yes');
} elseif (is_numeric($consent_raw)) {
    $consent = ((int) $consent_raw) ? 1 : 0;
} elseif (is_bool($consent_raw)) {
    $consent = $consent_raw ? 1 : 0;
}
if (!$consent && (int) get_option('aialttext_token_consent', 0) === 1) {
    $consent = 1;
}

    if ( ! $email || $password === '' || strlen($password) < 8 ) {
        wp_send_json_error(array('message' => __('Password must be at least 8 characters.', 'aialttext-token')), 400);
    }
    if ( ! $consent ) {
        wp_send_json_error(array('message' => __('Please agree to the Terms and Privacy Policy to continue.', 'aialttext-token')), 400);
    }

    $api    = new AiAltText_Token_API_Client();
    $result = $api->register_account($email, $password);

    if ( ! empty($result['success']) ) {
        if ( ! empty($result['access_key']) ) {
            update_option('aialttext_token_access_key', (string) $result['access_key']);
    
            // Any new key means we are no longer auto-logged-out.
            delete_transient('aialttext_token_auto_logged_out');
        }
        update_option('aialttext_token_account_email', $email);
        update_option('aialttext_token_consent', 1);
        update_option('aialttext_token_consent_ts', time());
    
        wp_send_json_success(array(
            'access_key'    => (string)($result['access_key'] ?? ''),
            'token_balance' => (int)($result['token_balance'] ?? 0),
            'existing'      => ! empty($result['existing_account']),
        ));
    }

    wp_send_json_error(array(
        'message' => isset($result['error']['message']) ? $result['error']['message'] : __('Registration failed', 'aialttext-token')
    ));
}

function aialttext_token_delete_account(){
    aialttext_token_check_nonce();

    // Owner-only: WordPress user email must match the linked account email.
    $current       = wp_get_current_user();
    $account_email = (string) get_option('aialttext_token_account_email', '');

    if ( ! $current || strcasecmp( (string) $current->user_email, $account_email ) !== 0 ) {
        wp_send_json_error(array(
            'message' => __('Only the account owner (WordPress user whose email matches the linked account email) can delete this account.', 'aialttext-token')
        ), 403);
    }

    $api    = new AiAltText_Token_API_Client();
    $result = $api->delete_account(); // sends { confirm: 1 } to the account server

    if ( ! empty($result['success']) ) {
        // Purge all local credentials and cached pricing/state.
        delete_option('aialttext_token_access_key');
        delete_option('aialttext_token_account_email');
        delete_transient('aialttext_token_pricing');

        wp_send_json_success(array('deleted' => true));
    }

    wp_send_json_error(array(
        'message' => isset($result['error']['message']) ? $result['error']['message'] : __('Deletion failed.', 'aialttext-token')
    ), 400);
}

function aialttext_token_logout_account() {
    aialttext_token_check_nonce();

    // Any user with “account” access may disconnect the site from the remote account.
    if ( ! aialttext_token_user_can('account') ) {
        wp_send_json_error(array('message' => __('You do not have permission to log out this connection.', 'aialttext-token')), 403);
    }

       // Remove local credentials so a different account can be linked next.
       delete_option('aialttext_token_access_key');

       // Clear any cached status/pricing so the next account sees fresh data.
       delete_transient('aialttext_token_status_cache');
       delete_transient('aialttext_token_pricing');
   
       wp_send_json_success(array('logged_out' => true));
}

/**
 * Non-AJAX logout for reliability and accessibility.
 * Mirrors the AJAX behavior, clears related local state, then redirects with a notice.
 */
function aialttext_token_logout_account_post() {
    aialttext_token_check_nonce();

    if ( ! aialttext_token_user_can('account') ) {
        wp_die( esc_html__('You do not have permission to log out this connection.', 'aialttext-token'), 403 );
    }

    // Clear local credentials and related cached UI state
    delete_option('aialttext_token_access_key');
    delete_option('aialttext_token_account_email'); // reset visible form/email
    delete_transient('aialttext_token_pricing');    // pricing cache used in UI
    delete_transient('aialttext_token_status_cache');

    /**
     * Fires after a successful local IMG Alt Gen Pro disconnect.
     * Allow integrations to tidy up.
     *
     * @since 3.0.0.4
     */
    do_action('aialttext_token_after_logout');

    // Redirect back to Account page with a success flag
    wp_safe_redirect( add_query_arg(
        array('page' => 'aialttext-token', 'loggedout' => '1'),
        admin_url('admin.php')
    ) );
    exit;
}

function aialttext_token_usage_page() {
    if ( ! aialttext_token_user_can('usage') ) {
        wp_die( esc_html__('You do not have permission to view this page.', 'aialttext-token') );
    }
    if ( ! aialttext_token_is_configured() ) {
        echo '<div class="notice notice-warning"><p>'
            . esc_html__('Please link your IMG Alt Gen account first. Go to Account & Tokens.', 'aialttext-token')
            . ' <a class="button button-secondary" href="' . esc_url( admin_url('admin.php?page=aialttext-token') ) . '">'
            . esc_html__('Open Account Page', 'aialttext-token') . '</a></p></div>';
        return;
    }
    ?>
    <div class="wrap aialttext-token-wrap">
        <h1><?php echo esc_html__('Usage History', 'aialttext-token'); ?></h1>
        <p class="aialttext-muted"><?php esc_html_e('Grouped by date. Click a date to expand.', 'aialttext-token'); ?></p>

        <div class="aialttext-usage-controls" style="display:flex;gap:8px;align-items:center;flex-wrap:wrap;margin-bottom:8px;">
            <label for="aialttext_usage_range" style="margin-right:4px;"><?php esc_html_e('Range', 'aialttext-token'); ?></label>
            <select id="aialttext_usage_range" class="regular-text">
                <option value="30"><?php esc_html_e('Last 30 days', 'aialttext-token'); ?></option>
                <option value="90"><?php esc_html_e('Last 90 days', 'aialttext-token'); ?></option>
                <option value="365"><?php esc_html_e('Up to 1 year', 'aialttext-token'); ?></option>
            </select>

            <button id="aialttext_token_load_usage" class="button button-secondary">
                <?php esc_html_e('Load Usage', 'aialttext-token'); ?>
            </button>

            <button id="aialttext_usage_expand_all" class="button" style="display:none;"><?php esc_html_e('Expand all', 'aialttext-token'); ?></button>
            <button id="aialttext_usage_collapse_all" class="button" style="display:none;"><?php esc_html_e('Collapse all', 'aialttext-token'); ?></button>
            <button id="aialttext_usage_load_more" class="button" style="display:none;"><?php esc_html_e('Load more', 'aialttext-token'); ?></button>
        </div>

        <div id="aialttext_token_usage_list" class="aialttext-usage" data-next-cursor=""></div>
    </div>
    <?php
}

function aialttext_token_settings_page(){
    if (!aialttext_token_user_can('settings')) return;

    if ( ! aialttext_token_is_configured() ) {
        echo '<div class="notice notice-warning"><p>'
            . esc_html__('Please link your IMG Alt Gen account first. Go to Account & Tokens.', 'aialttext-token')
            . ' <a class="button button-secondary" href="' . esc_url( admin_url('admin.php?page=aialttext-token') ) . '">'
            . esc_html__('Open Account Page', 'aialttext-token') . '</a></p></div>';
        return;
    }
    
    if (!empty($_POST['aialttext_token_save']) && check_admin_referer('aialttext_token_save')){
        update_option('aialttext_token_auto_generate', !empty($_POST['auto_generate']) ? 1 : 0);
        update_option('aialttext_token_show_indicators', !empty($_POST['show_indicators']) ? 1 : 0);

        // New: include descriptive filenames in AI context
        update_option('aialttext_token_use_filename_context', !empty($_POST['use_filename_context']) ? 1 : 0);
    
        // Save role access matrix
        if (isset($_POST['aialttext_token_role_access']) && is_array($_POST['aialttext_token_role_access'])) {
            $levels = array_keys(aialttext_token_get_access_levels());
            $clean  = array();
    
            foreach ((array) $_POST['aialttext_token_role_access'] as $role_key => $val) {
                $role_key = sanitize_key($role_key);
                $val      = sanitize_key($val);
                if (!in_array($val, $levels, true)) $val = 'none';
                $clean[$role_key] = $val;
            }
            update_option('aialttext_token_role_access', $clean);
        }
    
        // NEW: Save preferred output language (defaults to a guessed language if empty)
        $lang = isset($_POST['output_language']) ? sanitize_text_field($_POST['output_language']) : '';
        if ($lang === '') {
            $lang = function_exists('aialttext_token_guess_default_language')
                ? aialttext_token_guess_default_language()
                : 'English';
        }
         // Save UI language (Auto/en_US/de_DE…)
         $ui = isset($_POST['ui_language']) ? sanitize_text_field($_POST['ui_language']) : 'auto';
         update_option('aialttext_token_ui_language', $ui);
 
         update_option('aialttext_token_output_language', $lang);
        // We fix batch size at 1 for stability; users control bulk length via max_images.
$batch_size = 1;

$max_images  = isset($_POST['max_images']) ? absint($_POST['max_images']) : 0;
$max_images  = max(0, $max_images);

// allow placeholders, but strip tags
$prompt_template = isset($_POST['prompt_template']) ? wp_strip_all_tags((string) wp_unslash($_POST['prompt_template']), false) : '';

update_option('aialttext_token_batch_size', $batch_size);
update_option('aialttext_token_max_images', $max_images);
update_option('aialttext_token_prompt_template', $prompt_template);
        update_option('aialttext_token_woocommerce_integration', !empty($_POST['woocommerce_integration']) ? 1 : 0);
        update_option('aialttext_token_seo_integration', !empty($_POST['seo_integration']) ? 1 : 0);
        update_option('aialttext_token_hide_usage_panel', !empty($_POST['hide_usage_panel']) ? 1 : 0);
        
        echo '<div class="notice notice-success is-dismissible"><p>' . esc_html__('Settings saved.', 'aialttext-token') . '</p></div>';
    }
    
    $auto = get_option('aialttext_token_auto_generate', 0);
$ind = get_option('aialttext_token_show_indicators', 1);
// New: whether to include descriptive filenames in the AI prompt context
$use_filename_context = get_option('aialttext_token_use_filename_context', 1);
$batch = get_option('aialttext_token_batch_size', 1);
$max = get_option('aialttext_token_max_images', 0);
$tmpl = get_option('aialttext_token_prompt_template', 'Describe the image using the following context. Title: {title}. Context: {context}. Return only the alt text.');
$woo = get_option('aialttext_token_woocommerce_integration', 1);
$seo = get_option('aialttext_token_seo_integration', 1);
$hide_usage = get_option('aialttext_token_hide_usage_panel', 0);

// NEW: provide dropdown value & options
$output_language = get_option(
    'aialttext_token_output_language',
    function_exists('aialttext_token_guess_default_language') ? aialttext_token_guess_default_language() : 'English'
);
$lang_options = array(
    'Auto' => esc_html__('Auto (use site language)', 'aialttext-token'),
) + (function_exists('aialttext_token_get_language_options')
    ? aialttext_token_get_language_options()
    : array('English' => 'English'));
    
    ?>
    <div class="wrap aialttext-token-wrap">
    <h1><?php echo esc_html__('Img Alt Gen Pro - Settings', 'aialttext-token'); ?></h1>
        <div class="aialttext-token-card">
            <form method="post">
                <?php wp_nonce_field('aialttext_token_save'); ?>
                <table class="form-table">
                <tr>
                <th><?php esc_html_e('Auto-generate on upload', 'aialttext-token'); ?></th>
<td>
  <label class="aialttext-switch" for="aialttext_auto_generate">
    <input id="aialttext_auto_generate" type="checkbox" name="auto_generate" value="1" <?php checked($auto, 1); ?> role="switch" aria-checked="<?php echo $auto ? 'true' : 'false'; ?>" />
    <span class="aialttext-slider" aria-hidden="true"></span>
    <span class="aialttext-switch-label">
      <?php esc_html_e('Enable automatic alt text generation when images are uploaded', 'aialttext-token'); ?>
    </span>
  </label>

  <p class="description">
    <?php
    echo wp_kses_post(
      __('Note: when enabled, automatic generation runs for <strong>all users who can upload files</strong> (e.g. Authors, Editors), regardless of the access levels configured below.', 'aialttext-token')
    );
    ?>
  </p>
</td>
</tr>
                    <tr>
                    <th><?php esc_html_e('Show indicators in Media Library', 'aialttext-token'); ?></th>
<td>
  <label class="aialttext-switch" for="aialttext_show_indicators">
    <input id="aialttext_show_indicators" type="checkbox" name="show_indicators" value="1" <?php checked($ind, 1); ?> role="switch" aria-checked="<?php echo $ind ? 'true' : 'false'; ?>" />
    <span class="aialttext-slider" aria-hidden="true"></span>
    <span class="aialttext-switch-label">
      <?php esc_html_e('Show visual indicators for images with/without alt text', 'aialttext-token'); ?>
    </span>
  </label>
</td>
</tr>
<tr>
    <th><?php esc_html_e('Use filename in AI context', 'aialttext-token'); ?></th>
    <td>
        <label class="aialttext-switch" for="aialttext_use_filename_context">
            <input
                id="aialttext_use_filename_context"
                type="checkbox"
                name="use_filename_context"
                value="1"
                <?php checked( $use_filename_context, 1 ); ?>
                role="switch"
                aria-checked="<?php echo $use_filename_context ? 'true' : 'false'; ?>"
            />
            <span class="aialttext-slider" aria-hidden="true"></span>
            <span class="aialttext-switch-label">
                <?php esc_html_e('Include descriptive file names in the AI prompt (e.g. albany.jpeg, nike-airmax.svg)', 'aialttext-token'); ?>
            </span>
        </label>

        <p class="description">
            <?php esc_html_e('Generic names such as image.jpg or 13204i.png are automatically ignored.', 'aialttext-token'); ?>
        </p>
    </td>
</tr>
<tr>
    <th><?php esc_html_e( 'WooCommerce Integration', 'aialttext-token' ); ?></th>
    <td>
        <label class="aialttext-switch" for="aialttext_woocommerce_integration">
            <input
                id="aialttext_woocommerce_integration"
                type="checkbox"
                name="woocommerce_integration"
                value="1"
                <?php checked( $woo, 1 ); ?>
                role="switch"
                aria-checked="<?php echo $woo ? 'true' : 'false'; ?>"
            />
            <span class="aialttext-slider" aria-hidden="true"></span>
            <span class="aialttext-switch-label">
                <span class="aialttext-switch-label-main">
                    <?php esc_html_e(
                        'Include product information in alt text generation in WooCommerce Product pages.',
                        'aialttext-token'
                    ); ?>
                </span>
                <span class="aialttext-switch-label-note">
                    <?php esc_html_e(
                        '(*Note: This feature works for English output only)',
                        'aialttext-token'
                    ); ?>
                </span>
            </span>
        </label>
    </td>
</tr>

<tr>
    <th><?php esc_html_e( 'SEO Integration', 'aialttext-token' ); ?></th>
    <td>
        <label class="aialttext-switch" for="aialttext_seo_integration">
            <input
                id="aialttext_seo_integration"
                type="checkbox"
                name="seo_integration"
                value="1"
                <?php checked( $seo, 1 ); ?>
                role="switch"
                aria-checked="<?php echo $seo ? 'true' : 'false'; ?>"
            />
            <span class="aialttext-slider" aria-hidden="true"></span>
            <span class="aialttext-switch-label">
                <span class="aialttext-switch-label-main">
                    <?php esc_html_e(
                        'Include SEO keywords and meta descriptions in context when generating on posts',
                        'aialttext-token'
                    ); ?>
                </span>
                <span class="aialttext-switch-label-note">
                    <?php esc_html_e(
                        '(*Note: This feature works for English output only)',
                        'aialttext-token'
                    ); ?>
                </span>
            </span>
        </label>
    </td>
</tr>
<tr>
    <th></th>
    <td>
        <p class="description">
            <?php esc_html_e(
                'SEO and WooCommerce context are currently applied only when generating alt text from in-page editors (posts, pages, products). Bulk jobs do not yet include this additional context. Support for bulk jobs is coming soon.',
                'aialttext-token'
            ); ?>
        </p>
    </td>
</tr>

                    <tr>
                    <th><?php esc_html_e('Hide Token Balance Panel', 'aialttext-token'); ?></th>
<td>
  <label class="aialttext-switch" for="aialttext_hide_usage_panel">
    <input id="aialttext_hide_usage_panel" type="checkbox" name="hide_usage_panel" value="1" <?php checked($hide_usage, 1); ?> role="switch" aria-checked="<?php echo $hide_usage ? 'true' : 'false'; ?>" />
    <span class="aialttext-slider" aria-hidden="true"></span>
    <span class="aialttext-switch-label">
      <?php esc_html_e('Hide the token usage panel in the bulk processing tool', 'aialttext-token'); ?>
    </span>
  </label>
</td>
</tr>
                   <!-- <tr>
                    <th><?php esc_html_e('Images per request', 'aialttext-token'); ?></th>
    <td>
        <input type="number" value="1" disabled readonly class="small-text" />
        <em><?php esc_html_e('Fixed at 1 for reliability on larger libraries.', 'aialttext-token'); ?></em>
        Keep a hidden field so existing save logic and nonce flow remain intact 
        <input type="hidden" name="batch_size" value="1" />
    </td>
</tr>-->
                   <!-- <tr>
                        <th>Max images per session</th>
                        <td>
                            <input type="number" min="0" name="max_images" value="<?php echo esc_attr($max); ?>" /> 
                            <em>0 = unlimited</em>
                        </td>
                    </tr> -->

                    <?php
$ui_locale        = get_option('aialttext_token_ui_language', 'auto');
$ui_locale_opts   = function_exists('aialttext_token_get_ui_locale_options')
    ? aialttext_token_get_ui_locale_options()
    : array('auto' => 'Auto', 'en_US' => 'English');
?>
<tr>
    <th><?php esc_html_e('Plugin display language', 'aialttext-token'); ?></th>
    <td>
        <select name="ui_language" style="min-width:260px;">
            <?php foreach ($ui_locale_opts as $code => $label): ?>
                <option value="<?php echo esc_attr($code); ?>" <?php selected($ui_locale, $code); ?>>
                    <?php echo esc_html($label); ?>
                </option>
            <?php endforeach; ?>
        </select>
        <p class="description">
            <?php esc_html_e('Auto matches the user’s WordPress admin language; if no matching translation exists, English is used.', 'aialttext-token'); ?>
        </p>
    </td>
</tr>

                    <tr>
    <th><?php esc_html_e('Default output language', 'aialttext-token'); ?></th>
    <td>
        <select name="output_language" style="min-width:260px;">
            <?php foreach ($lang_options as $label => $label2): ?>
                <option value="<?php echo esc_attr($label); ?>" <?php selected($output_language, $label); ?>>
                    <?php echo esc_html($label); ?>
                </option>
            <?php endforeach; ?>
        </select>
        <p class="description">
            <?php esc_html_e('The AI will return all ALT text in this language.', 'aialttext-token'); ?>
        </p>
    </td>
</tr>
                

                    <!--
                    <tr>
    <th>Prompt template</th>
    <td>
        <textarea name="prompt_template" rows="4" class="large-text"><?php echo esc_textarea($tmpl); ?></textarea>
        <p class="description">Variables: {title}, {context}</p>
    </td>
</tr>
-->

<tr>
    <th><?php esc_html_e('Role Access', 'aialttext-token'); ?></th>
    <td>
        <?php
        $roles  = function_exists('get_editable_roles') ? get_editable_roles() : array();
        $levels = aialttext_token_get_access_levels();
        $map    = aialttext_token_get_role_access_map();
        ?>
        <div class="aialttext-token-access">
        <p class="description" style="margin-top:0;">
    <p><?php esc_html_e('Choose what each role can do inside IMG Alt Gen Pro.', 'aialttext-token'); ?></p>
    <p><?php esc_html_e('Full: Includes Account & Settings.', 'aialttext-token'); ?></p>
    <p><?php esc_html_e('Partial: Adds Bulk Processing.', 'aialttext-token'); ?></p>
    <p><?php esc_html_e('Generate Only: shows per-image buttons but no Bulk/Settings.', 'aialttext-token'); ?></p>
</p>
            <table class="wp-list-table widefat fixed striped aialttext-access-table" style="margin-top:12px;">
                <thead>
                    <tr>
                    <th style="width:40%;"><?php esc_html_e('Role', 'aialttext-token'); ?></th>
<th><?php esc_html_e('Access', 'aialttext-token'); ?></th>
                    </tr>
                </thead>
                <tbody>
                <?php foreach ($roles as $role_key => $role_info): 
                    $label = isset($role_info['name'])
                    ? translate_user_role( $role_info['name'] )
                    : $role_key;
                    $current = isset($map[$role_key]) ? $map[$role_key] : 'none';
                ?>
                    <tr>
                    <td>
    <strong><?php echo esc_html( $label ); ?></strong>
    <span class="screen-reader-text"> (<?php echo esc_html( $role_key ); ?>)</span>
</td>
                        <td>
                            <select name="aialttext_token_role_access[<?php echo esc_attr($role_key); ?>]" style="min-width:220px;">
                                <?php foreach ($levels as $val => $text): ?>
                                    <option value="<?php echo esc_attr($val); ?>" <?php selected($current, $val); ?>>
                                        <?php echo esc_html($text); ?>
                                    </option>
                                <?php endforeach; ?>
                            </select>
                        </td>
                    </tr>
                <?php endforeach; ?>
                </tbody>
            </table>
        </div>
    </td>
</tr>
                
                </table>
                <p>
                <button class="button button-primary-save-settings"><?php esc_html_e('Save Settings', 'aialttext-token'); ?></button>
                    <input type="hidden" name="aialttext_token_save" value="1" />
                </p>
            </form>
        </div>
    </div>
    <?php
}

function aialttext_token_process_page(){
    if ( ! aialttext_token_user_can('bulk') ) return;
if ( ! aialttext_token_is_configured() ) {
    echo '<div class="notice notice-warning"><p>'
        . esc_html__('Please link your IMG Alt Gen account first. Go to Account & Tokens.', 'aialttext-token')
        . ' <a class="button button-secondary" href="' . esc_url( admin_url('admin.php?page=aialttext-token') ) . '">'
        . esc_html__('Open Account Page', 'aialttext-token') . '</a></p></div>';
    return;
}
    
    // Get current token balance
    $current_balance = aialttext_token_check_balance();
    
    ?>
    <div class="wrap aialttext-token-wrap">
    <h1><?php echo esc_html__( 'IMG Alt Gen Pro', 'aialttext-token' ); ?></h1>
<style>
/* Token thresholds */
.aialttext-tokens-remaining.aialttext-warn   { color:#d97706; } /* orange */
.aialttext-tokens-remaining.aialttext-danger { color:#b91c1c; } /* red */

/* Keep the preview cards’ vibe, just add a line for alt text */
.aialttext-images-grid .aialttext-image-item .aialttext-image-alt{
  margin-top:6px; font-size:12px; line-height:1.4; color:#ffffff;
  word-break:break-word;
}

/* Gentle sticky banner shown during processing */
.aialttext-processing-banner{
  position:sticky; top:32px; z-index:10;
  background:#fff8e6; border-left:4px solid #f59e0b; padding:10px 14px;
  margin:10px 0 0; border-radius:6px; color:#111111;
}
/* Success state once everything is done */
.aialttext-processing-banner.is-complete{
  background:#ecfdf5;             /* soft green */
  border-left-color:#10b981;       /* emerald */
  color:#111111;
  
}
</style>
        
        <div class="aialttext-modern-interface">
            <!-- Left Panel: Batch Processing -->
            <div class="aialttext-batch-panel">

            <h2><?php esc_html_e( 'Batch Processing', 'aialttext-token' ); ?></h2>
            <p class="description" id="aialttext_output_language_notice">
    <?php
    $effective = function_exists('aialttext_token_resolve_output_language')
        ? aialttext_token_resolve_output_language()
        : get_option('aialttext_token_output_language', 'English');
    printf( esc_html__('Alt text will be generated in: %s', 'aialttext-token'), esc_html($effective) );
    ?>
</p>

<div id="aialttext_processing_banner" class="aialttext-processing-banner" style="display:none;">
<strong><?php esc_html_e('Working…', 'aialttext-token'); ?></strong>
<?php esc_html_e('Please keep this page open while images are being processed.', 'aialttext-token'); ?>
</div>
                <div class="aialttext-progress-section">
                    <div class="aialttext-progress-header">
                    <span class="aialttext-progress-label" id="aialttext_progress_label">
                    <?php esc_html_e('Scan to find images without alt text', 'aialttext-token'); ?>
</span>

<!-- keep these counters in the DOM (hidden) so existing JS that updates them
     continues to run harmlessly; they’re not used for display anymore -->
<span id="aialttext_token_processed_count" class="screen-reader-text" aria-hidden="true">0</span>
<span id="aialttext_token_total_images" class="screen-reader-text" aria-hidden="true">0</span>
                        <span class="aialttext-progress-indicator active" id="aialttext_progress_indicator">●</span>
                    </div>
                    
                    <div id="aialttext_token_progress_bar" class="aialttext-modern-progress-bar">
                        <div id="aialttext_token_progress" class="aialttext-modern-progress"></div>
                    </div>
                    
                    <div class="aialttext-controls">
                    <label class="aialttext-switch" style="margin-right:12px;">
  <input type="checkbox" id="aialttext_only_published" />
  <span class="aialttext-slider"></span>
</label>
<span class="aialttext-switch-label">
  <?php esc_html_e('Only images used on published posts/pages', 'aialttext-token'); ?>
</span>
<button class="button button-primary aialttext-scan-btn" id="aialttext_token_process_button">
  <?php esc_html_e('Scan to find images without alt text', 'aialttext-token'); ?>
</button>
<button class="button button-secondary aialttext-stop-btn" id="aialttext_token_stop_button" style="display:none;"><?php esc_html_e('Stop Processing', 'aialttext-token'); ?></button>
</div>

<!-- NEW: optional per-run limit -->
<div class="aialttext-limit">
<label for="aialttext_token_limit" class="screen-reader-text"><?php esc_html_e('How many images to process', 'aialttext-token'); ?></label>
    <input
        type="number"
        id="aialttext_token_limit"
        class="aialttext-limit-input"
        min="1"
        step="1"
        placeholder="<?php esc_attr_e('All available', 'aialttext-token'); ?>"
        aria-describedby="aialttext_limit_hint"
    />
    <div id="aialttext_limit_hint" class="aialttext-limit-hint">
    <?php esc_html_e('Leave empty to process all available images.', 'aialttext-token'); ?>
</div>
</div>
                </div>
            </div>
            
            <!-- Right Panel: Token Usage -->
            <div class="aialttext-token-panel" id="aialttext_token_usage_panel" <?php if(get_option('aialttext_token_hide_usage_panel', 0)) echo 'style="display:none;"'; ?>>
            <h2><?php esc_html_e('Token Usage', 'aialttext-token'); ?></h2>
                <div class="aialttext-token-display">
                    <div class="aialttext-token-amount">
                        <span class="aialttext-tokens-used" id="aialttext_tokens_used">0</span>
                        <span class="aialttext-token-separator">/</span>
                        <span class="aialttext-tokens-remaining"
                              id="aialttext_tokens_remaining"
                              data-initial-balance="<?php echo esc_attr( (string) $current_balance ); ?>">
                            <?php echo esc_html( $current_balance ); ?>
                        </span>
                    </div>
                    <div class="aialttext-token-label">
                    <span class="aialttext-token-used-label"><?php esc_html_e('Images Processed', 'aialttext-token'); ?></span>
<span class="aialttext-token-remaining-label"><?php esc_html_e('Tokens Remaining', 'aialttext-token'); ?></span>
                    </div>
                    <?php if ( function_exists( 'aialttext_token_user_can' ) && aialttext_token_user_can( 'account' ) ) : ?>
    <a href="<?php echo esc_url( admin_url('admin.php?page=aialttext-token') ); ?>" class="aialttext-manage-tokens">
        <?php esc_html_e('Manage tokens', 'aialttext-token'); ?> →
    </a>
<?php endif; ?>
                </div>
            </div>
            
            <!-- Bottom Panel: Latest Images -->
<div class="aialttext-images-panel" id="aialttext_token_latest_images" style="display:none;">
    <div class="aialttext-images-grid" id="aialttext_images_grid"></div>

    <!-- New: controls for paginating processed thumbnails -->
    <div class="aialttext-images-controls" id="aialttext_images_controls" style="display:none;">
    <button type="button" class="button button-secondary aialttext-show-more" id="aialttext_show_more" style="display:none;"><?php esc_html_e('Show more', 'aialttext-token'); ?></button>
<button type="button" class="button button-secondary aialttext-show-all"  id="aialttext_show_all"  style="display:none;"><?php esc_html_e('Show all processed', 'aialttext-token'); ?></button>
</div>
</div>
        </div>
        
        <!-- Status and Error Messages -->
        <div id="aialttext_token_process_status" class="aialttext-token-process-status" style="margin-top: 20px;"></div>
        <div id="aialttext_token_error_details" class="aialttext-token-error-details"></div>
        
        <!-- Hidden legacy containers for compatibility -->
        <div style="display: none;">
            <span id="aialttext_token_error_count">0</span>
            <span id="aialttext_token_time_remaining"><?php esc_html_e('Unknown', 'aialttext-token'); ?></span>
        </div>
    </div>
    <?php
}

function aialttext_token_help_page(){
    ?>
    <div class="wrap aialttext-token-wrap aialttext-dark">
    <h1><?php echo esc_html__('AI Alt Text Generator – Help & Documentation', 'aialttext-token'); ?></h1>

        <!-- Debug/Test Section 
        <div class="aialttext-token-card">
            <h2>🔧 Debug & Test Context Detection</h2>
            <p>Use this tool to test if SEO and WooCommerce context detection is working properly.</p>
            
            <div style="display: grid; grid-template-columns: 1fr 1fr; gap: 20px; margin: 20px 0;">
                <div>
                    <label for="test-post-id"><strong>Post/Product ID to Test:</strong></label><br>
                    <input type="number" id="test-post-id" placeholder="Enter post/product ID" style="width: 100%; margin: 5px 0;">
                    <button type="button" id="test-context-btn" class="button button-primary">Test Context Detection</button>
                </div>
                <div>
                    <label><strong>Test Results:</strong></label>
                    <div id="test-results" style="background: #f9f9f9; padding: 10px; border-radius: 4px; font-family: monospace; font-size: 12px; height: 200px; overflow: auto;">Click "Test Context Detection" to see results...</div>
                </div>
            </div>
            
            <script>
            jQuery(document).ready(function($) {

                // === Account UI: show logout, hide link, and disable email when linked ===
var isLinked = <?php echo ! empty($access_key) ? 'true' : 'false'; ?>;
if (isLinked) {
    jQuery('#aialttext_token_link_account_btn').hide();
    jQuery('#aialttext_token_logout_btn').show();
    jQuery('#aialttext_token_account_email').prop('disabled', true);
} else {
    jQuery('#aialttext_token_logout_btn').hide();
}

// === Logout click ===
jQuery('#aialttext_token_logout_btn').off('click').on('click', function(e){
    e.preventDefault();
    if (!confirm('<?php echo esc_js(__('Log out of this account on this site?', 'aialttext-token')); ?>')) return;
    jQuery.ajax({
        url: (window.ajaxurl || '<?php echo esc_url( admin_url('admin-ajax.php') ); ?>'),
        type: 'POST',
        dataType: 'json',
        data: {
            action: 'aialttext_token_logout_account',
            nonce: '<?php echo wp_create_nonce('aialttext_token_nonce'); ?>'
        },
        success: function(res){
            if (res && res.success) {
                // simplest, safest: refresh to redraw the whole section
                window.location.reload();
            } else {
                alert((res && res.data && res.data.message) ? res.data.message : '<?php echo esc_js(__('Logout failed.', 'aialttext-token')); ?>');
            }
        },
        error: function(){
            alert('<?php echo esc_js(__('Logout failed.', 'aialttext-token')); ?>');
        }
    });
});

// === Delete account modal ===
jQuery('#aialttext_token_delete_account_btn').off('click').on('click', function(e){
    e.preventDefault();
    // reset modal state each time it opens
    jQuery('#aialttext_delete_ack').prop('checked', false);
    jQuery('#aialttext_delete_confirm').prop('disabled', true);
    jQuery('#aialttext-delete-modal').show();
});
jQuery('#aialttext_delete_cancel').off('click').on('click', function(e){
    e.preventDefault();
    // reset on close for clean re-open behavior
    jQuery('#aialttext_delete_ack').prop('checked', false);
    jQuery('#aialttext_delete_confirm').prop('disabled', true);
    jQuery('#aialttext-delete-modal').hide();
});
jQuery('#aialttext_delete_ack').off('change').on('change', function(){
    jQuery('#aialttext_delete_confirm').prop('disabled', !this.checked);
});
jQuery('#aialttext_delete_confirm').off('click').on('click', function(e){
    e.preventDefault();
    if (jQuery(this).is(':disabled')) return;

    jQuery(this).prop('disabled', true);

    jQuery.ajax({
        url: (window.ajaxurl || '<?php echo esc_url( admin_url('admin-ajax.php') ); ?>'),
        type: 'POST',
        dataType: 'json',
        data: {
            action: 'aialttext_token_delete_account',
            nonce: '<?php echo wp_create_nonce('aialttext_token_nonce'); ?>'
        },
        success: function(res){
            if (res && res.success) {
                // Clear UI by reloading
                window.location.reload();
            } else {
                alert((res && res.data && res.data.message) ? res.data.message : '<?php echo esc_js(__('Deletion failed.', 'aialttext-token')); ?>');
                jQuery('#aialttext_delete_confirm').prop('disabled', false);
            }
        },
        error: function(){
            alert('<?php echo esc_js(__('Deletion failed.', 'aialttext-token')); ?>');
            jQuery('#aialttext_delete_confirm').prop('disabled', false);
        }
    });
});

                $('#test-context-btn').click(function() {
                    var postId = $('#test-post-id').val();
                    if (!postId) {
                        alert('Please enter a post/product ID');
                        return;
                    }
                    
                    $('#test-results').text('Testing...');
                    
                    $.ajax({
                        url: (window.ajaxurl || '<?php echo esc_url( admin_url('admin-ajax.php') ); ?>'),
                        type: 'POST',
                        data: {
                            action: 'aialttext_token_test_context',
                            post_id: postId,
                            nonce: '<?php echo wp_create_nonce('aialttext_token_nonce'); ?>'
                        },
                        success: function(response) {
                            if (response.success) {
                                var html = '';
                                html += '=== POST DETAILS ===\n';
                                html += 'ID: ' + response.data.post_details.ID + '\n';
                                html += 'Type: ' + response.data.post_details.post_type + '\n';
                                html += 'Title: ' + response.data.post_details.post_title + '\n\n';
                                
                                html += '=== SETTINGS ===\n';
                                html += 'WooCommerce Integration: ' + (response.data.settings.woocommerce_integration ? 'Enabled' : 'Disabled') + '\n';
                                html += 'SEO Integration: ' + (response.data.settings.seo_integration ? 'Enabled' : 'Disabled') + '\n';
                                html += 'Auto Generate: ' + (response.data.settings.auto_generate ? 'Enabled' : 'Disabled') + '\n';
                                html += 'WooCommerce Active: ' + (response.data.settings.woocommerce_active ? 'Yes' : 'No') + '\n';
                                html += 'Yoast Active: ' + (response.data.settings.yoast_active ? 'Yes' : 'No') + '\n';
                                if (response.data.yoast_focus_keyphrase !== undefined) {
                                    html += 'Yoast Focus Keyphrase: ' + (response.data.yoast_focus_keyphrase || 'None set') + '\n';
                                }
                                html += '\n';
                                
                                if (response.data.post_context) {
                                    html += '=== FULL CONTEXT (What AI receives) ===\n';
                                    html += response.data.post_context + '\n\n';
                                }
                                
                                if (response.data.woo_context) {
                                    html += '=== WOOCOMMERCE CONTEXT ===\n';
                                    html += response.data.woo_context + '\n\n';
                                }
                                
                                if (response.data.seo_context) {
                                    html += '=== SEO CONTEXT ===\n';
                                    html += response.data.seo_context + '\n\n';
                                }
                                
                                if (!response.data.post_context && !response.data.woo_context && !response.data.seo_context) {
                                    html += '⚠️ NO CONTEXT DETECTED!\n';
                                    html += 'This means context detection is not working properly.\n';
                                }
                                
                                $('#test-results').text(html);
                            } else {
                                $('#test-results').text('Error: ' + (response.data ? response.data.message : 'Unknown error'));
                            }
                        },
                        error: function() {
                            $('#test-results').text(
  (window.wp && wp.i18n) ? wp.i18n.__('AJAX Error: Could not connect to server', 'aialttext-token')
                         : 'AJAX Error: Could not connect to server'
);
                        }
                    });
                });
            });
            </script>
        </div> -->

        <?php
    // Work out what this user can actually do inside the plugin.
    $access_level  = function_exists( 'aialttext_token_get_user_access_level' )
        ? aialttext_token_get_user_access_level()
        : 'full';

    $access_labels = function_exists( 'aialttext_token_get_access_levels' )
        ? aialttext_token_get_access_levels()
        : array();

    $access_label = isset( $access_labels[ $access_level ] )
        ? $access_labels[ $access_level ]
        : ucwords( str_replace( '_', ' ', (string) $access_level ) );

    $can_account  = function_exists( 'aialttext_token_user_can' ) ? aialttext_token_user_can( 'account' )  : true;
    $can_settings = function_exists( 'aialttext_token_user_can' ) ? aialttext_token_user_can( 'settings' ) : true;
    $can_bulk     = function_exists( 'aialttext_token_user_can' ) ? aialttext_token_user_can( 'bulk' )     : true;
    $can_generate = function_exists( 'aialttext_token_user_can' ) ? aialttext_token_user_can( 'generate' ) : true;
    $can_usage    = function_exists( 'aialttext_token_user_can' ) ? aialttext_token_user_can( 'usage' )    : true;
?>

<div class="aialttext-token-card">
    <h2><?php esc_html_e( 'Help & Documentation', 'aialttext-token' ); ?></h2>

    <p class="description">
        <?php
        echo wp_kses_post(
            sprintf(
                /* translators: %s is the current user's access label (Full / Partial / Generate Only / No Access). */
                __( 'Your IMG Alt Gen access level is <strong>%s</strong>. This controls which plugin pages you can see.', 'aialttext-token' ),
                esc_html( $access_label )
            )
        );
        ?>
    </p>

    <!-- Quick Start -->
    <div class="aialttext-token-help-section">
        <h3><?php esc_html_e( 'Quick Start', 'aialttext-token' ); ?></h3>
        <ol>
            <li>
                <?php if ( $can_account ) : ?>
                    <?php
                    printf(
                        wp_kses_post(
                            /* translators: %s is the URL to the Account & Tokens admin page. */
                            __( 'Open <a href="%s">Account &amp; Tokens</a> and link your site (enter your email, then click <em>Link / Relink</em>). New accounts receive <strong>10 free tokens</strong>.', 'aialttext-token' )
                        ),
                        esc_url( admin_url( 'admin.php?page=aialttext-token' ) )
                    );
                    ?>
                    <br />
                    <?php
                    echo wp_kses_post(
                        sprintf(
                            /* translators: 1: opening <a> tag, 2: closing </a> tag. */
                            __( 'To manage billing, token bundles, invoices and connected sites, use the %1$sIMG Alt Gen account dashboard%2$s on our main product site.', 'aialttext-token' ),
                            '<a href="https://www.imgaltgen.com/account" target="_blank" rel="noopener">',
                            '</a>'
                        )
                    );
                    ?>
                <?php else : ?>
                    <?php
                    esc_html_e(
                        'Your IMG Alt Gen account and tokens are managed by a site administrator. Once they have linked the site and added tokens, you can start generating alt text.', 
                        'aialttext-token'
                    );
                    ?>
                <?php endif; ?>
            </li>

            <li>
                <?php if ( $can_settings ) : ?>
                    <?php esc_html_e( 'Visit', 'aialttext-token' ); ?>
                    <a href="<?php echo esc_url( admin_url( 'admin.php?page=aialttext-token-settings' ) ); ?>">
                        <?php esc_html_e( 'Settings', 'aialttext-token' ); ?>
                    </a>
                    <?php esc_html_e( 'to configure:', 'aialttext-token' ); ?>
                    <ul>
                        <li><?php esc_html_e( 'Automatic alt text generation on upload', 'aialttext-token' ); ?></li>
                        <li><?php esc_html_e( 'WooCommerce product context & SEO plugin integrations', 'aialttext-token' ); ?></li>
                        <li><?php esc_html_e( 'Prompt template, batch size and bulk run cap', 'aialttext-token' ); ?></li>
                        <li><?php esc_html_e( 'Default output language for generated alt text', 'aialttext-token' ); ?></li>
                        <li><?php esc_html_e( 'Visual indicators in the Media Library', 'aialttext-token' ); ?></li>
                        <li><?php esc_html_e( 'Role-based access (Full / Partial / Generate / None)', 'aialttext-token' ); ?></li>
                    </ul>
                <?php else : ?>
                    <?php
                    esc_html_e(
                        'Your site administrator controls IMG Alt Gen settings such as automatic generation, integrations, language, and bulk limits.', 
                        'aialttext-token'
                    );
                    ?>
                <?php endif; ?>
            </li>

            <?php if ( $can_bulk ) : ?>
                <li>
                    <?php esc_html_e( 'Go to', 'aialttext-token' ); ?>
                    <a href="<?php echo esc_url( admin_url( 'admin.php?page=aialttext-token-process' ) ); ?>">
                        <?php esc_html_e( 'Bulk Process Images', 'aialttext-token' ); ?>
                    </a>
                    <?php esc_html_e( 'to generate alt text for images that are missing it.', 'aialttext-token' ); ?>
                </li>
            <?php elseif ( $can_generate ) : ?>
                <li>
                    <?php
                    esc_html_e(
                        'Use the per-image “Generate Alt Text” buttons in the Media Library or the Image block in Gutenberg to generate alt text as you work.', 
                        'aialttext-token'
                    );
                    ?>
                </li>
            <?php endif; ?>
        </ol>
    </div>

    <!-- Using the Features -->
    <div class="aialttext-token-help-section">
        <h3><?php esc_html_e( 'Using the Features', 'aialttext-token' ); ?></h3>
        <ul>
            <li>
                <?php
                echo wp_kses_post(
                    sprintf(
                        __( '%1$s When enabled, uploaded images are queued for processing. Existing alt text is never overwritten.', 'aialttext-token' ),
                        '<strong>' . esc_html__( 'Automatic generation:', 'aialttext-token' ) . '</strong>'
                    )
                );
                ?>
            </li>

            <?php if ( $can_bulk ) : ?>
                <li>
                    <?php
                    echo wp_kses_post(
                        sprintf(
                            __( '%1$s The Bulk page lists images without alt text. Use the optional limit to cap a run; token usage updates live as images are processed.', 'aialttext-token' ),
                            '<strong>' . esc_html__( 'Bulk processing:', 'aialttext-token' ) . '</strong>'
                        )
                    );
                    ?>
                </li>
            <?php endif; ?>

            <?php if ( $can_generate ) : ?>
                <li>
                    <?php
                    echo wp_kses_post(
                        sprintf(
                            /* translators: %2$s is the "Generate Alt Text" label. */
                            __( '%1$s Dots show status (green = has alt text, grey = missing). Each image has a %2$s action.', 'aialttext-token' ),
                            '<strong>' . esc_html__( 'Media Library indicators:', 'aialttext-token' ) . '</strong>',
                            '<em>' . esc_html__( 'Generate Alt Text', 'aialttext-token' ) . '</em>'
                        )
                    );
                    ?>
                </li>

                <li>
                    <?php
                    echo wp_kses_post(
                        sprintf(
                            /* translators: %2$s is the "Generate Alt Text" label. */
                            __( '%1$s Select an Image block and click %2$s in the block toolbar or panel to generate alt text in place.', 'aialttext-token' ),
                            '<strong>' . esc_html__( 'Gutenberg:', 'aialttext-token' ) . '</strong>',
                            '<em>' . esc_html__( 'Generate Alt Text', 'aialttext-token' ) . '</em>'
                        )
                    );
                    ?>
                </li>
            <?php endif; ?>

            <li>
                <?php
                echo wp_kses_post(
                    '<strong>' . esc_html__( 'WooCommerce:', 'aialttext-token' ) . '</strong> ' .
                    esc_html__( 'Product images automatically use product title, attributes and short description for context.', 'aialttext-token' )
                );
                ?>
            </li>

            <li>
                <?php
                echo wp_kses_post(
                    '<strong>' . esc_html__( 'SEO context:', 'aialttext-token' ) . '</strong> ' .
                    esc_html__( 'If a supported SEO plugin is active (Yoast, Rank Math, AIOSEO, SEOPress), the focus keyphrase and meta description are included in the prompt.', 'aialttext-token' )
                );
                ?>
            </li>

            <li>
                <?php
                echo wp_kses_post(
                    '<strong>' . esc_html__( 'Prompt template & language:', 'aialttext-token' ) . '</strong> ' .
                    esc_html__( 'You can customise the output style and choose a default output language in Settings. The AI uses post, product and SEO context to match your content.', 'aialttext-token' )
                );
                ?>
            </li>

            <li>
                <?php
                echo wp_kses_post(
                    '<strong>' . esc_html__( 'Permissions:', 'aialttext-token' ) . '</strong> ' .
                    esc_html__( 'Access is set per role as:', 'aialttext-token' ) . ' ' .
                    '<em>' . esc_html__( 'Full', 'aialttext-token' ) . '</em> ' .
                    esc_html__( '(all pages),', 'aialttext-token' ) . ' ' .
                    '<em>' . esc_html__( 'Partial', 'aialttext-token' ) . '</em> ' .
                    esc_html__( '(Bulk + per-image tools),', 'aialttext-token' ) . ' ' .
                    '<em>' . esc_html__( 'Generate', 'aialttext-token' ) . '</em> ' .
                    esc_html__( '(single-image only),', 'aialttext-token' ) . ' ' .
                    esc_html__( 'or', 'aialttext-token' ) . ' ' .
                    '<em>' . esc_html__( 'None', 'aialttext-token' ) . '</em>.'
                );
                ?>
            </li>
        </ul>
    </div>

    <!-- Token System -->
    <div class="aialttext-token-help-section">
        <h3><?php esc_html_e( 'Token System', 'aialttext-token' ); ?></h3>
        <ul>
            <li>
                <?php
                echo wp_kses_post(
                    '<strong>' . esc_html__( '1 token = 1 image', 'aialttext-token' ) . '</strong> ' .
                    esc_html__( 'processed.', 'aialttext-token' )
                );
                ?>
            </li>

            <li>
                <?php if ( $can_account ) : ?>
                    <?php
                    echo wp_kses_post(
                        esc_html__( 'Manage tokens from', 'aialttext-token' ) . ' ' .
                        '<a href="' . esc_url( admin_url( 'admin.php?page=aialttext-token' ) ) . '">' .
                        esc_html__( 'Account & Tokens', 'aialttext-token' ) .
                        '</a>. ' .
                        esc_html__( 'Purchased bundles activate instantly and are shared by all sites linked to the same IMG Alt Gen account.', 'aialttext-token' )
                    );
                    ?>
                <?php else : ?>
                    <?php
                    esc_html_e(
                        'Tokens are shared at account level and are managed by the site owner. If you see token or quota errors, contact an administrator with Full access.', 
                        'aialttext-token'
                    );
                    ?>
                <?php endif; ?>
            </li>

            <li>
                <?php esc_html_e( 'If tokens run out, processing pauses until more are added.', 'aialttext-token' ); ?>
            </li>

            <?php if ( $can_usage ) : ?>
                <li>
                    <?php
                    printf(
                        wp_kses_post(
                            /* translators: %s is the URL to the Usage History page. */
                            __( 'To review past usage grouped by date, open <a href="%s">Usage History</a> in the IMG Alt Gen menu.', 'aialttext-token' )
                        ),
                        esc_url( admin_url( 'admin.php?page=aialttext-token-usage' ) )
                    );
                    ?>
                </li>
            <?php endif; ?>
        </ul>
    </div>

    <!-- FAQ -->
    <div class="aialttext-token-help-section">
        <h3><?php esc_html_e( 'FAQ', 'aialttext-token' ); ?></h3>

        <div class="aialttext-token-faq">
            <h4><?php esc_html_e( 'Will existing alt text be changed?', 'aialttext-token' ); ?></h4>
            <div class="aialttext-token-faq-answer">
                <p><?php esc_html_e( 'No. Only images without alt text are processed.', 'aialttext-token' ); ?></p>
            </div>

            <h4><?php esc_html_e( 'Can I generate alt text for a single image?', 'aialttext-token' ); ?></h4>
            <div class="aialttext-token-faq-answer">
                <p>
                    <?php
                    echo wp_kses_post(
                        sprintf(
                            /* translators: %s is the emphasized "Generate Alt Text" label. */
                            __( 'Yes. Use the Media Library’s %s action or the Image block button in Gutenberg.', 'aialttext-token' ),
                            '<em>' . esc_html__( 'Generate Alt Text', 'aialttext-token' ) . '</em>'
                        )
                    );
                    ?>
                </p>
            </div>

            <h4><?php esc_html_e( 'What data leaves my site?', 'aialttext-token' ); ?></h4>
            <div class="aialttext-token-faq-answer">
                <p>
                    <?php
                    esc_html_e(
                        'Only minimal context (titles, captions, product details and SEO hints) is sent securely to the AI. Image data is handled securely and transiently; only the generated alt text is stored back on your site.', 
                        'aialttext-token'
                    );
                    ?>
                </p>
            </div>

            <h4><?php esc_html_e( 'Can I see what images have been processed?', 'aialttext-token' ); ?></h4>
            <div class="aialttext-token-faq-answer">
                <p>
                    <?php if ( $can_usage ) : ?>
                        <?php
                        esc_html_e(
                            'Yes. Open the Usage History page from the IMG Alt Gen menu to see grouped usage over time.', 
                            'aialttext-token'
                        );
                        ?>
                    <?php else : ?>
                        <?php
                        esc_html_e(
                            'Yes. An administrator with Full access can see detailed Usage History inside WordPress and share reports if required.', 
                            'aialttext-token'
                        );
                        ?>
                    <?php endif; ?>
                </p>
            </div>
        </div>
    </div>

    <!-- Support -->
    <div class="aialttext-token-help-section">
        <h3><?php esc_html_e( 'Support', 'aialttext-token' ); ?></h3>
        <ul>
            <li>
                <?php
                echo wp_kses_post(
                    esc_html__( 'Email:', 'aialttext-token' ) . ' ' .
                    '<a href="mailto:contact@imgaltgen.com">contact@imgaltgen.com</a>'
                );
                ?>
            </li>
            <li>
                <?php
                echo wp_kses_post(
                    esc_html__( 'Documentation:', 'aialttext-token' ) . ' ' .
                    '<a href="https://imgaltgen.com/docs" target="_blank" rel="noopener">https://imgaltgen.com/docs</a>'
                );
                ?>
            </li>
        </ul>
    </div>
</div>
    </div>
    <?php
}
        
        


// Ajax: account UI
add_action('wp_ajax_aialttext_token_link_account',  'aialttext_token_link_account');
add_action('wp_ajax_aialttext_token_login_account', 'aialttext_token_login_account');
add_action('wp_ajax_aialttext_token_register_account', 'aialttext_token_register_account');
add_action('wp_ajax_aialttext_token_delete_account',   'aialttext_token_delete_account');
add_action('wp_ajax_aialttext_token_refresh_balance', 'aialttext_token_refresh_balance');
add_action('wp_ajax_aialttext_token_get_pricing', 'aialttext_token_get_pricing');
add_action('wp_ajax_aialttext_token_purchase_tokens', 'aialttext_token_purchase_tokens');
add_action('wp_ajax_aialttext_token_confirm_payment', 'aialttext_token_confirm_payment');
add_action('wp_ajax_aialttext_token_load_usage', 'aialttext_token_load_usage');
// Non-AJAX fallback: secure logout via admin-post.php (logged-in only)
add_action('admin_post_aialttext_token_logout_account', 'aialttext_token_logout_account_post');
// Explicitly deny non-logged-in access (defense-in-depth)
add_action('admin_post_nopriv_aialttext_token_logout_account', '__return_false');

// NEW: does this email already exist? (used to set button text)
add_action('wp_ajax_aialttext_token_account_exists', 'aialttext_token_account_exists');
function aialttext_token_account_exists() {
    aialttext_token_check_nonce();
    if ( ! aialttext_token_user_can('account') ) {
        wp_send_json_error(array('message' => __('Insufficient privileges', 'aialttext-token')));
    }
    $email = sanitize_email($_POST['email'] ?? '');
    if ( ! $email ) {
        wp_send_json_error(
            array( 'message' => __( 'Email required', 'aialttext-token' ) ),
            400
        );
    }
    $api = new AiAltText_Token_API_Client();
    $res = $api->account_exists($email);
    if ( isset($res['success']) && $res['success'] ) {
        wp_send_json_success(array('exists' => (bool) ($res['exists'] ?? ( $res['data']['exists'] ?? false ))));
    }
    wp_send_json_error(array('message' => ( $res['error']['message'] ?? 'Lookup failed') ));
}

// NEW: trigger password-reset email (from admin site)
// This is invoked by the “Forgot password?” link in the client UI
add_action('wp_ajax_aialttext_token_password_forgot', 'aialttext_token_password_forgot');
function aialttext_token_password_forgot() {
    aialttext_token_check_nonce();
    if ( ! aialttext_token_user_can('account') ) {
        wp_send_json_error(array('message' => __('Insufficient privileges', 'aialttext-token')));
    }
    $email = sanitize_email($_POST['email'] ?? '');
    if ( ! $email ) {
        wp_send_json_error(
            array( 'message' => __( 'Email required', 'aialttext-token' ) ),
            400
        );
    }
    $api = new AiAltText_Token_API_Client();
    $res = $api->password_forgot($email);
    if ( isset($res['success']) && $res['success'] ) {
        wp_send_json_success(array('sent' => true));
    }
    wp_send_json_error(array('message' => ( $res['error']['message'] ?? 'Could not send reset email') ));
}

/**
 * Resolve an attachment ID from an image URL with several fallbacks:
 * - Core attachment_url_to_postid()
 * - Strip query/fragment and -{w}x{h} sized suffix
 * - Lookup by _wp_attached_file (meta) and by GUID
 * - If on CDN/offload, attempt to replace base URL with uploads base URL
 */
function aialttext_token_find_attachment_id_by_url( $url ) {
    $url = (string) $url;
    if ( $url === '' ) {
        return 0;
    }

    // 1) Core best-effort
    $id = attachment_url_to_postid( $url );
    if ( $id ) {
        return (int) $id;
    }

    // Normalize (remove query/fragment)
    $clean = strtok( $url, '?#' );
    $path  = wp_parse_url( $clean, PHP_URL_PATH );
    if ( ! $path ) {
        return 0;
    }

    // Basename and strip common size suffix (e.g., -300x200)
    $basename          = wp_basename( $path );
    $basename_nosize   = preg_replace( '/-\d+x\d+(?=\.[^.]+$)/', '', $basename );
    $basename_nosize   = sanitize_file_name( $basename_nosize );

    global $wpdb;

    // 2) Try by _wp_attached_file (ends-with match to catch year/month subdirs)
    $like = $wpdb->esc_like( $basename_nosize );
    $sql  = $wpdb->prepare(
        "SELECT p.ID
         FROM {$wpdb->posts} p
         JOIN {$wpdb->postmeta} m
           ON m.post_id = p.ID AND m.meta_key = '_wp_attached_file'
        WHERE p.post_type = 'attachment'
          AND ( m.meta_value LIKE %s )
        ORDER BY p.ID DESC
        LIMIT 1",
        '%' . $like
    );
    $id = (int) $wpdb->get_var( $sql );
    if ( $id ) {
        return $id;
    }

    // 3) Try by GUID (some setups keep the full URL there)
    $sql = $wpdb->prepare(
        "SELECT ID
         FROM {$wpdb->posts}
        WHERE post_type = 'attachment'
          AND guid LIKE %s
        ORDER BY ID DESC
        LIMIT 1",
        '%' . $like
    );
    $id = (int) $wpdb->get_var( $sql );
    if ( $id ) {
        return $id;
    }

    // 4) CDN/offload: try replacing upstream host with uploads baseurl if path contains /uploads/
    $uploads = wp_get_upload_dir();
    if ( ! empty( $uploads['baseurl'] ) ) {
        $pos = strpos( $clean, '/uploads/' );
        if ( false !== $pos ) {
            $relative = ltrim( substr( $clean, $pos + 1 ), '/' ); // 'uploads/2025/10/file.jpg'
            $local    = trailingslashit( $uploads['baseurl'] ) . ltrim( $relative, '/' );
            $id       = attachment_url_to_postid( $local );
            if ( $id ) {
                return (int) $id;
            }
        }
    }

    return 0;
}

// Map external image URLs to local Media Library items (1 batch request)
add_action('wp_ajax_aialttext_token_map_urls_to_media', 'aialttext_token_map_urls_to_media');
function aialttext_token_map_urls_to_media() {
    aialttext_token_check_nonce();
    if ( ! current_user_can('upload_files') ) {
        wp_send_json_error(
            array( 'message' => __( 'Insufficient privileges', 'aialttext-token' ) ),
            403
        );
    }

    $urls = isset($_POST['urls']) ? (array) $_POST['urls'] : array();
    $urls = array_filter(array_map('esc_url_raw', $urls));
    $map  = array();

    foreach ( $urls as $u ) {
        $id = aialttext_token_find_attachment_id_by_url( $u );
    
        if ( $id ) {
            $edit = get_edit_post_link( $id, 'raw' );
            if ( ! $edit ) {
                $edit = admin_url( 'post.php?post=' . (int) $id . '&action=edit' );
            }
    
            $map[ $u ] = array(
                'id'        => (int) $id,
                'edit_link' => $edit,
                'thumb'     => wp_get_attachment_image_url( $id, 'thumbnail' ),
            );
        } else {
            $map[ $u ] = null;
        }
    }

    if (defined('AIALTTEXT_ACCOUNT_DEBUG') && AIALTTEXT_ACCOUNT_DEBUG && function_exists('error_log')) {
        error_log('[AI Alt Text] URL->Media map: ' . wp_json_encode(array_keys($map)));
    }
    wp_send_json_success( array('map' => $map) );
}

// Ajax: processing
add_action('wp_ajax_aialttext_token_list_missing', 'aialttext_token_list_missing');

function aialttext_token_check_nonce(){
    $nonce = isset($_REQUEST['nonce']) ? sanitize_text_field((string) $_REQUEST['nonce']) : '';
    if ( ! wp_verify_nonce($nonce, 'aialttext_token_nonce') ) {
        if (defined('DOING_AJAX') && DOING_AJAX) {
            wp_send_json_error(array('message' => __('Security check failed', 'aialttext-token')), 400);
        } else {
            wp_die(esc_html__('Security check failed', 'aialttext-token'), 403);
        }
    }
}

function aialttext_token_link_account(){
    aialttext_token_check_nonce();
    if ( ! aialttext_token_user_can('account') ) {
        wp_send_json_error(array('message' => __('Insufficient privileges', 'aialttext-token')));
    }

    $email    = sanitize_email($_POST['email'] ?? '');
    $password = isset($_POST['password']) ? (string) wp_unslash($_POST['password']) : '';
    $consent_raw = $_POST['consent'] ?? null;
$consent     = 0;
if (is_string($consent_raw)) {
    $cr = strtolower(trim((string) $consent_raw));
    $consent = (int) ($cr === '1' || $cr === 'true' || $cr === 'on' || $cr === 'yes');
} elseif (is_numeric($consent_raw)) {
    $consent = ((int) $consent_raw) ? 1 : 0;
} elseif (is_bool($consent_raw)) {
    $consent = $consent_raw ? 1 : 0;
}
// If they accepted before, honor it
if (!$consent && (int) get_option('aialttext_token_consent', 0) === 1) {
    $consent = 1;
}

    if ( ! $email ) {
        wp_send_json_error(array('message' => __('Email required', 'aialttext-token')));
    }
    if ( ! $password || strlen($password) < 8 ) {
        wp_send_json_error(array('message' => __('Password (min. 8 chars) required', 'aialttext-token')));
    }
    if ( ! $consent ) {
        wp_send_json_error(array('message' => __('Please agree to the Terms and Privacy Policy to continue.', 'aialttext-token')));
    }

    update_option('aialttext_token_account_email', $email);
    // Record consent locally (timestamped)
update_option('aialttext_token_consent', 1);
update_option('aialttext_token_consent_ts', time());

    $api    = new AiAltText_Token_API_Client();
    $domain = parse_url(get_site_url(), PHP_URL_HOST);
    $result = $api->link_account($email, $password, $domain);

    if (!empty($result['success'])) {
        if (!empty($result['access_key'])) {
            update_option('aialttext_token_access_key', $result['access_key']);
            // Record when this key was issued so we can avoid over-aggressive auto-logout.
            update_option('aialttext_token_access_key_issued_at', time());
    
            // New key means any cached status is now stale; force a fresh fetch next time.
            delete_transient('aialttext_token_status_cache');
    
            // Ensure any previous auto-logout warning is cleared once the account is re-linked.
            delete_transient('aialttext_token_auto_logged_out');
        }
        wp_send_json_success(array(
            'message' => isset($result['message']) ? $result['message'] : 'Linked',
            'balance' => isset($result['token_balance']) ? $result['token_balance'] : 0
        ));
    }

    wp_send_json_error(array('message' => isset($result['error']['message']) ? $result['error']['message'] : 'Failed to link'));
}

function aialttext_token_login_account(){
    aialttext_token_check_nonce();
    if ( ! aialttext_token_user_can('account') ) {
        wp_send_json_error(array('message' => __('Insufficient privileges', 'aialttext-token')));
    }
    $email    = sanitize_email($_POST['email'] ?? '');
    $password = isset($_POST['password']) ? (string) wp_unslash($_POST['password']) : '';
    $consent_raw = $_POST['consent'] ?? null;
$consent     = 0;
if (is_string($consent_raw)) {
    $cr = strtolower(trim((string) $consent_raw));
    $consent = (int) ($cr === '1' || $cr === 'true' || $cr === 'on' || $cr === 'yes');
} elseif (is_numeric($consent_raw)) {
    $consent = ((int) $consent_raw) ? 1 : 0;
} elseif (is_bool($consent_raw)) {
    $consent = $consent_raw ? 1 : 0;
}
// previously accepted consent remains valid
if (!$consent && (int) get_option('aialttext_token_consent', 0) === 1) {
    $consent = 1;
}

    if ( ! $email || $password === '' || strlen($password) < 8 ) {
        wp_send_json_error(array('message' => __('Password must be at least 8 characters.', 'aialttext-token')), 400);
    }
    if ( ! $consent ) {
        wp_send_json_error(array('message' => __('Please agree to the Terms and Privacy Policy to continue.', 'aialttext-token')), 400);
    }

    update_option('aialttext_token_account_email', $email);
    update_option('aialttext_token_consent', 1);
update_option('aialttext_token_consent_ts', time());

    $api = new AiAltText_Token_API_Client();
    $result = $api->login_account($email, $password);

    if (!empty($result['success']) && !empty($result['access_key'])) {
        update_option('aialttext_token_access_key', $result['access_key']);
        // Track key issuance time for smarter auth error handling.
        update_option('aialttext_token_access_key_issued_at', time());
    
        // Clear any cached status so the next balance check uses this new key.
        delete_transient('aialttext_token_status_cache');
    
        // Clear any auto-logout flag once login succeeds.
        delete_transient('aialttext_token_auto_logged_out');
    
        wp_send_json_success(array(
            'message' => isset($result['message']) ? $result['message'] : __('Logged in', 'aialttext-token'),
            'balance' => isset($result['token_balance']) ? (int)$result['token_balance'] : 0,
        ));
    }

    wp_send_json_error(array(
        'message' => isset($result['error']['message']) ? $result['error']['message'] : __('Login failed', 'aialttext-token')
    ));
}

function aialttext_token_refresh_balance(){
    aialttext_token_check_nonce();
    if ( ! aialttext_token_user_can('account') ) {
        wp_send_json_error(array('message' => __('Insufficient privileges', 'aialttext-token')));
    }
    delete_transient( 'aialttext_token_status_cache' );
    $api = new AiAltText_Token_API_Client(); 
    $result = $api->status();
    
    if (!empty($result['success'])) {
        wp_send_json_success(array('balance' => $result['token_balance']));
    }
    
    // If account/key is invalid server-side, auto-logout here too.
    $err_code = strtolower((string) ($result['error']['code'] ?? ''));
    if (in_array($err_code, array('not_found','invalid_key','auth','unauthorized'), true)) {
        delete_option('aialttext_token_access_key');
        delete_transient('aialttext_token_status_cache');
        set_transient('aialttext_token_auto_logged_out', 1, HOUR_IN_SECONDS);
        do_action('aialttext_token_after_logout');
        wp_send_json_success(array('logged_out' => true));
    }
    
    wp_send_json_error(array('message' => isset($result['error']['message']) ? $result['error']['message'] : 'Unable to fetch balance'));
}

function aialttext_token_get_pricing(){ 
    aialttext_token_check_nonce(); 
    if ( ! aialttext_token_user_can('account') ) {
        wp_send_json_error(array('message' => __('Insufficient privileges', 'aialttext-token')));
    }
    $result = aialttext_token_cached_pricing(); 
    
    if (!empty($result['success'])) {
        wp_send_json_success($result); 
    }
    
    wp_send_json_error(array('message' => isset($result['error']['message']) ? $result['error']['message'] : 'Pricing not available')); 
}

function aialttext_token_purchase_tokens(){
    aialttext_token_check_nonce();
    if ( ! aialttext_token_user_can('account') ) {
        wp_send_json_error(array('message' => __('Insufficient privileges', 'aialttext-token')));
    }
    $pkg = sanitize_text_field(isset($_POST['package_id']) ? $_POST['package_id'] : '');
    if (!$pkg) wp_send_json_error(array('message' => 'Missing package'));
    
    $base = admin_url('admin.php?page=aialttext-token');
    $success = $base . (strpos($base, '?') !== false ? '&' : '?') . 'payment=success&session_id={CHECKOUT_SESSION_ID}';
    $cancel = $base . (strpos($base, '?') !== false ? '&' : '?') . 'payment=cancelled';
    
    $api = new AiAltText_Token_API_Client();
    $result = $api->purchase($pkg, $success, $cancel, parse_url(get_site_url(), PHP_URL_HOST));
    
    if (!empty($result['success']) && !empty($result['checkout_url'])) {
        wp_send_json_success(array(
            'checkout_url' => $result['checkout_url'],
            'session_id' => $result['session_id']
        ));
    }
    
    wp_send_json_error(array('message' => isset($result['error']['message']) ? $result['error']['message'] : 'Payment could not be initiated'));
}
function aialttext_token_confirm_payment(){
    aialttext_token_check_nonce();
    if ( ! aialttext_token_user_can('account') ) {
        wp_send_json_error(array('message' => __('Insufficient privileges', 'aialttext-token')), 403);
    }
    $session_id = sanitize_text_field(isset($_POST['session_id']) ? $_POST['session_id'] : '');
    if (!$session_id) wp_send_json_error(array('message' => __('Missing session ID', 'aialttext-token')));
    
    $api = new AiAltText_Token_API_Client();
    $result = $api->confirm($session_id);
    
    if (!empty($result['success'])){
        delete_transient( 'aialttext_token_status_cache' );
        $status_result = $api->status();
        $balance = !empty($status_result['success']) ? (isset($status_result['token_balance']) ? $status_result['token_balance'] : null) : null;
        $added = isset($result['tokens_added']) ? intval($result['tokens_added']) : 0;
        $pkg = isset($result['package_tokens']) ? intval($result['package_tokens']) : $added;
        
        /* translators: %d is the number of tokens added, e.g., 50 */
$message = sprintf(
    __('Payment confirmed. %d tokens added to your account.', 'aialttext-token'),
    ($added > 0 ? $added : $pkg)
);

wp_send_json_success(array(
    'message'        => $message,
    'tokens_added'   => $added,
    'package_tokens' => $pkg,
    'balance'        => $balance
));
    }
    
    wp_send_json_error(array('message' => isset($result['error']['message']) ? $result['error']['message'] : __('Payment confirmation failed', 'aialttext-token')));
}

function aialttext_token_load_usage(){
    aialttext_token_check_nonce();
    if ( ! aialttext_token_user_can('account') ) {
        wp_send_json_error(array('message' => __('Insufficient privileges', 'aialttext-token')));
    }

    // Sanitize & forward filters
    $args = array();

    if (isset($_POST['days']))      { $args['days']      = max(1, min(365, (int) $_POST['days'])); }
    if (isset($_POST['per_page']))  { $args['per_page']  = max(1, min(200, (int) $_POST['per_page'])); }
    if (isset($_POST['cursor']))    { $args['cursor']    = max(0, (int) $_POST['cursor']); }

    if (!empty($_POST['start_date'])) { $args['start_date'] = sanitize_text_field( wp_unslash($_POST['start_date']) ); }
    if (!empty($_POST['end_date']))   { $args['end_date']   = sanitize_text_field( wp_unslash($_POST['end_date']) ); }

    // Always scope to this site unless explicitly overridden
if ( empty($args['domain']) ) {
    $host = wp_parse_url( home_url(), PHP_URL_HOST );
    if ( is_string($host) && $host !== '' ) {
        $args['domain'] = $host;
    }
}

    $api    = new AiAltText_Token_API_Client();
    $result = $api->usage($args);

    if (!empty($result['success'])) {
        wp_send_json_success($result);
    }

    $msg = (!empty($result['error']['message'])) ? $result['error']['message'] : 'Unable to load usage data';
    wp_send_json_error(array('message' => $msg));
}

function aialttext_token_support_page(){
    // Only users with Support permission (Partial / Full) can see this page
    if ( ! function_exists('aialttext_token_user_can') || ! aialttext_token_user_can('support') ) {
        return;
    }
    $client = new AiAltText_Token_API_Client();
    $notice = '';

    // Handle new ticket submit (server-side POST)
    if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST['aialttext_support_submit'])) {
        check_admin_referer('aialttext_support_submit','aialttext_support_nonce');

        $payload = array(
          'first_name'    => sanitize_text_field($_POST['first_name'] ?? ''),
          'surname'       => sanitize_text_field($_POST['surname'] ?? ''),
          'business_name' => sanitize_text_field($_POST['business_name'] ?? ''),
          'tel'           => sanitize_text_field($_POST['tel'] ?? ''),
          'domain_url'    => esc_url_raw($_POST['domain_url'] ?? ''),
          'contact_email' => sanitize_email($_POST['contact_email'] ?? ''),
          'issue_type'    => sanitize_text_field($_POST['issue_type'] ?? ''),
          'description'   => wp_kses_post($_POST['description'] ?? ''),
        );
        $resp = $client->submit_support_ticket($payload);
        if (!empty($resp['success'])) {
            $notice = '<div class="updated"><p>Support ticket submitted. ID: '.(int)$resp['ticket_id'].'</p></div>';
        } else {
            $msg = !empty($resp['error']['message']) ? esc_html($resp['error']['message']) : 'Error submitting ticket.';
            $notice = '<div class="error"><p>'.$msg.'</p></div>';
        }
    }

    // Detail view with reply
    $ticket_id = isset($_GET['ticket']) ? (int) $_GET['ticket'] : 0;
    echo '<div class="wrap aialttext-token-wrap aialttext-support"><h1 class=".support-ticket-submit-a-ticket">'.esc_html__('Support', 'aialttext-token').'</h1>';
    if ($notice) echo $notice;

    if ($ticket_id) {
        $data = $client->get_support_ticket($ticket_id);
        if (empty($data['success'])) {
            echo '<p>'.esc_html__('Ticket not found or unauthorized.', 'aialttext-token').'</p></div>'; return;
        }
        $t = $data['ticket']; $msgs = $data['replies'];
        echo '<h2>'.sprintf(esc_html__('Ticket #%d – %s (%s)', 'aialttext-token'), (int)$t['id'], esc_html($t['issue_type']), esc_html($t['status'])).'</h2>';
        echo '<div style="background:#fff;border:1px solid #ccd0d4;padding:12px;">';
        foreach ($msgs as $m) {
            $who = ($m['author_type'] === 'admin') ? __('Support','aialttext-token') : __('You','aialttext-token');
            echo '<p><em>['.esc_html($m['created_at']).'] '.$who.':</em><br>'.wp_kses_post(wpautop($m['message'])).'</p><hr>';
        }
        echo '</div>';

        // Reply form
        echo '<h3>'.esc_html__('Add Reply', 'aialttext-token').'</h3>
        <form method="post" action="'.esc_url(admin_url('admin-ajax.php')).'">
          <input type="hidden" name="action" value="aialttext_token_support_reply"/>
          <input type="hidden" name="ticket_id" value="'.(int)$t['id'].'"/>
          '.wp_nonce_field('aialttext_token_support_reply','aialttext_token_support_reply_nonce', true, false).'
          <textarea name="message" rows="5" class="large-text" required></textarea>
          <p><button class="button button-primary">'.esc_html__('Send Reply','aialttext-token').'</button></p>
        </form>';
        echo '</div>'; return;
    }

    // New ticket form + list
    $me = wp_get_current_user();
    $default_email = get_option('aialttext_token_account_email', $me->user_email);

    ?>
    <div class="aialttext-support-inner">
      <h2 class="support-ticket-submit-a-ticket"><?php esc_html_e('Submit a Ticket', 'aialttext-token'); ?></h2>
      <form method="post">
        <?php wp_nonce_field('aialttext_support_submit','aialttext_support_nonce'); ?>
      <table class="form-table">
        <tr><th><?php esc_html_e('First Name*','aialttext-token'); ?></th>
            <td><input name="first_name" class="regular-text" required></td></tr>
        <tr><th><?php esc_html_e('Surname*','aialttext-token'); ?></th>
            <td><input name="surname" class="regular-text" required></td></tr>
        <tr><th><?php esc_html_e('Business Name','aialttext-token'); ?></th>
            <td><input name="business_name" class="regular-text"></td></tr>
        <tr><th><?php esc_html_e('Tel No','aialttext-token'); ?></th>
            <td><input name="tel" class="regular-text"></td></tr>
        <tr><th><?php esc_html_e('Domain URL','aialttext-token'); ?></th>
            <td><input name="domain_url" class="regular-text" value="<?php echo esc_attr(home_url()); ?>"></td></tr>
        <tr><th><?php esc_html_e('Contact Email*','aialttext-token'); ?></th>
            <td><input name="contact_email" type="email" class="regular-text" value="<?php echo esc_attr($default_email); ?>" required></td></tr>
        <tr><th><?php esc_html_e('Issue Type*','aialttext-token'); ?></th>
            <td><select name="issue_type" required>
                <option value="technical"><?php esc_html_e('Technical','aialttext-token'); ?></option>
                <option value="payment"><?php esc_html_e('Payment','aialttext-token'); ?></option>
                <option value="usage"><?php esc_html_e('Usage','aialttext-token'); ?></option>
            </select></td></tr>
        <tr><th><?php esc_html_e('Description*','aialttext-token'); ?></th>
            <td><textarea name="description" rows="6" class="large-text" required></textarea></td></tr>
      </table>
      <p><button class="button button-primary" name="aialttext_support_submit" value="1"><?php esc_html_e('Submit Ticket','aialttext-token'); ?></button></p>
    </form>

    <h2 class="support-submit-ticket"><?php esc_html_e('My Tickets', 'aialttext-token'); ?></h2>
    <?php
      $list = $client->list_support_tickets();
      if (!empty($list['success']) && !empty($list['tickets'])) {
          echo '<table class="wp-list-table widefat striped"><thead><tr><th>ID</th><th>'.esc_html__('Issue','aialttext-token').'</th><th>'.esc_html__('Status','aialttext-token').'</th><th>'.esc_html__('Updated','aialttext-token').'</th><th></th></tr></thead><tbody>';
          foreach ($list['tickets'] as $t) {
            echo '<tr><td>'.(int)$t['id'].'</td><td>'.esc_html($t['issue_type']).'</td><td>'.esc_html($t['status']).'</td><td>'.esc_html($t['updated_at']).'</td><td><a class="button button-small" href="'.esc_url(admin_url('admin.php?page=aialttext-token-support&ticket='.(int)$t['id'])).'">'.esc_html__('Open','aialttext-token').'</a></td></tr>';
          }
          echo '</tbody></table>';
        } else {
            echo '<p>'.esc_html__('No tickets yet.','aialttext-token').'</p>';
        }
      ?>
      </div><!-- .aialttext-support-inner -->
      <?php
      echo '</div>';
  }

function aialttext_token_list_missing(){
    aialttext_token_check_nonce();
    if ( ! aialttext_token_user_can('account') ) {
        wp_send_json_error(array('message' => __('Insufficient privileges', 'aialttext-token')));
    }
    global $wpdb;
    
    $max = max(0, intval(get_option('aialttext_token_max_images', 0)));
    $limit_sql = $max > 0 ? $wpdb->prepare("LIMIT %d", $max) : "";
    
    $ids = $wpdb->get_col("
        SELECT p.ID
        FROM {$wpdb->posts} p
        LEFT JOIN {$wpdb->postmeta} m ON m.post_id=p.ID AND m.meta_key='_wp_attachment_image_alt'
        WHERE p.post_type='attachment' AND p.post_mime_type LIKE 'image/%'
        AND (m.meta_value IS NULL OR m.meta_value='')
        ORDER BY p.ID DESC
        $limit_sql
    ");
    
    wp_send_json_success(array('ids' => array_map('intval', $ids)));
}