<?php
// File: ai-alt-text-generator-token/uninstall.php
if (!defined('WP_UNINSTALL_PLUGIN')) {
    exit;
}

/**
 * Options used by IMG Alt Gen Pro (token version)
 * Sourced from the plugin codebase.
 */
$options = array(
    'aialttext_token_access_key',
    'aialttext_token_account_email',
    'aialttext_token_auto_generate',
    'aialttext_token_max_images',
    'aialttext_token_woocommerce_integration',
    'aialttext_token_seo_integration',
    'aialttext_token_show_indicators',
    'aialttext_token_output_language',
    'aialttext_token_ui_language',
    'aialttext_token_role_access',
    'aialttext_token_hide_usage_panel',
    'aialttext_token_do_activation_redirect',
    'aialttext_token_version',
    'aialttext_token_batch_size',
    'aialttext_token_prompt_template',
    'aialttext_token_debug_upgrade',
);

// Remove options for a single blog.
$delete_options = function() use ($options) {
    global $wpdb;

    foreach ($options as $key) {
        delete_option($key);
        delete_site_option($key); // no-op on non-multisite
    }

    // Remove transients used by this plugin.
    // Known names/prefixes:
    // - 'aialttext_token_pricing'
    // - 'aialttext_current_editing_post_' (prefix, per-post)
    $wpdb->query( "DELETE FROM {$wpdb->options} WHERE option_name IN ('_transient_aialttext_token_pricing','_transient_timeout_aialttext_token_pricing')" );
    $wpdb->query( $wpdb->prepare(
        "DELETE FROM {$wpdb->options} WHERE option_name LIKE %s OR option_name LIKE %s",
        $wpdb->esc_like('_transient_aialttext_current_editing_post_') . '%',
        $wpdb->esc_like('_transient_timeout_aialttext_current_editing_post_') . '%'
    ) );
};

if (is_multisite()) {
    $sites = get_sites(array('fields' => 'ids'));
    foreach ($sites as $blog_id) {
        switch_to_blog($blog_id);
        $delete_options();
        restore_current_blog();
    }
    // Clean up network-level options just in case
    $delete_options();
} else {
    $delete_options();
}