<?php
if (!defined('ABSPATH')) exit;

function aialttext_token_account_page(){
    if (!aialttext_token_user_can('account')) return;
    
    $email = get_option('aialttext_token_account_email', get_option('admin_email'));
    $access_key = get_option('aialttext_token_access_key', '');
    $masked_key = $access_key ? substr($access_key, 0, 6) . '••••••' . substr($access_key, -4) : '—';
    $show_success = (!empty($_GET['payment']) && $_GET['payment'] === 'success' && !empty($_GET['session_id']));
    
    ?>
    <div class="wrap aialttext-token-wrap">
    <h1><?php echo esc_html__('AI Alt Text Generator – Account & Tokens', 'aialttext-token'); ?></h1>
        <?php /* JS will handle the purchase popup; removed server-side banner to avoid duplicates. */ ?>
        
        <div class="aialttext-section-stack aialttext-dark">
            <div class="aialttext-token-card">
            <h2><?php esc_html_e('Account', 'aialttext-token'); ?></h2>
                <?php $is_linked = ! empty($access_key); ?>
<?php if ($is_linked): ?>
    <div class="notice notice-success is-dismissible">
    <p>
  <strong><?php echo esc_html__('Account linked.', 'aialttext-token'); ?></strong>
  <?php echo esc_html__('Your site is connected to IMG Alt Gen Pro and ready to use.', 'aialttext-token'); ?>
</p>
    </div>
<?php endif; ?>
                <?php $is_linked = ! empty($access_key); ?>
<?php if (!$is_linked): ?>
    <p>
  <strong><?php echo esc_html__('Welcome!', 'aialttext-token'); ?></strong>
  <?php echo wp_kses_post(
    sprintf(
      /* translators: 1: UI label for link button, 2: number of free tokens */
      __('Enter your email and click <em>%1$s</em> to connect your account and instantly claim your free <strong>%2$d tokens</strong>.', 'aialttext-token'),
      esc_html__('Link / Relink', 'aialttext-token'),
      10
    )
  ); ?>
</p>
<?php endif; ?>
                <table class="form-table">
                    <tr>
                    <th><?php esc_html_e('Email', 'aialttext-token'); ?></th>
                        <td>
                        <input type="email" id="aialttext_token_account_email" value="<?php echo esc_attr($email); ?>" class="regular-text" />
                        <button id="aialttext_token_link_account_btn" class="button button-secondary<?php echo $is_linked ? '' : ' aialttext-onboard-pulse'; ?>">
  <?php esc_html_e('Link / Relink', 'aialttext-token'); ?>
</button>
<?php if (!$is_linked): ?>
    <p id="aialttext-onboard-tip" class="description aialttext-onboard-tip">
    <?php
    echo wp_kses_post( sprintf(
        /* translators: %s is the number of free tokens */
        __('First time here? Enter your email above and click <em>Link Account</em> to connect your account and instantly claim your free <strong>%s tokens</strong>.', 'aialttext-token'),
        10
    ) );
    ?>
</p>
<?php endif; ?>
                        </td>
                    </tr>
                    <tr>
                    <th><?php esc_html_e('Token Balance', 'aialttext-token'); ?></th>
                        <td>
                        <span id="aialttext-token-balance"><?php echo esc_html((string) aialttext_token_check_balance()); ?></span>
                        <a href="#" id="aialttext_token_refresh_balance"><?php esc_html_e('Refresh', 'aialttext-token'); ?></a>
                        </td>
                    </tr>
                    <tr>
                    <th><?php esc_html_e('Access Key', 'aialttext-token'); ?></th>
                        <td><code><?php echo esc_html($masked_key); ?></code></td>
                    </tr>
                </table>
            </div>
            
            <div class="aialttext-token-card">
            <h2><?php esc_html_e('Purchase More Tokens - 1 Token Per Image', 'aialttext-token'); ?></h2>
                <div id="aialttext_token_pricing" class="aialttext-token-pricing"></div>
            </div>
        </div>
        
        <section class="aialttext-token-card aialttext-token-section">
        <h2><?php esc_html_e('Usage History', 'aialttext-token'); ?></h2>
<p class="aialttext-muted"><?php esc_html_e('Grouped by date. Click a date to expand.', 'aialttext-token'); ?></p>
<button id="aialttext_token_load_usage" class="button button-secondary"><?php esc_html_e('Load Usage History', 'aialttext-token'); ?></button>
<button id="aialttext_usage_expand_all" class="button" style="display:none;"><?php esc_html_e('Expand all', 'aialttext-token'); ?></button>
<button id="aialttext_usage_collapse_all" class="button" style="display:none;"><?php esc_html_e('Collapse all', 'aialttext-token'); ?></button>
    </div>
    <div id="aialttext_token_usage_list" class="aialttext-usage"></div>
</section>
        </div>
    </div>
    <?php
}

function aialttext_token_settings_page(){
    if (!aialttext_token_user_can('settings')) return;
    
    if (!empty($_POST['aialttext_token_save']) && check_admin_referer('aialttext_token_save')){
        update_option('aialttext_token_auto_generate', !empty($_POST['auto_generate']) ? 1 : 0);
        update_option('aialttext_token_show_indicators', !empty($_POST['show_indicators']) ? 1 : 0);
    
        // Save role access matrix
        if (isset($_POST['aialttext_token_role_access']) && is_array($_POST['aialttext_token_role_access'])) {
            $levels = array_keys(aialttext_token_get_access_levels());
            $clean  = array();
    
            foreach ((array) $_POST['aialttext_token_role_access'] as $role_key => $val) {
                $role_key = sanitize_key($role_key);
                $val      = sanitize_key($val);
                if (!in_array($val, $levels, true)) $val = 'none';
                $clean[$role_key] = $val;
            }
            update_option('aialttext_token_role_access', $clean);
        }
    
        // NEW: Save preferred output language (defaults to a guessed language if empty)
        $lang = isset($_POST['output_language']) ? sanitize_text_field($_POST['output_language']) : '';
        if ($lang === '') {
            $lang = function_exists('aialttext_token_guess_default_language')
                ? aialttext_token_guess_default_language()
                : 'English';
        }
        update_option('aialttext_token_output_language', $lang);
        // We fix batch size at 1 for stability; users control bulk length via max_images.
$batch_size = 1;

$max_images  = isset($_POST['max_images']) ? absint($_POST['max_images']) : 0;
$max_images  = max(0, $max_images);

// allow placeholders, but strip tags
$prompt_template = isset($_POST['prompt_template']) ? wp_strip_all_tags((string) wp_unslash($_POST['prompt_template']), false) : '';

update_option('aialttext_token_batch_size', $batch_size);
update_option('aialttext_token_max_images', $max_images);
update_option('aialttext_token_prompt_template', $prompt_template);
        update_option('aialttext_token_woocommerce_integration', !empty($_POST['woocommerce_integration']) ? 1 : 0);
        update_option('aialttext_token_seo_integration', !empty($_POST['seo_integration']) ? 1 : 0);
        update_option('aialttext_token_hide_usage_panel', !empty($_POST['hide_usage_panel']) ? 1 : 0);
        
        echo '<div class="notice notice-success is-dismissible"><p>' . esc_html__('Settings saved.', 'aialttext-token') . '</p></div>';
    }
    
    $auto = get_option('aialttext_token_auto_generate', 0);
$ind = get_option('aialttext_token_show_indicators', 1);
$batch = get_option('aialttext_token_batch_size', 1);
$max = get_option('aialttext_token_max_images', 0);
$tmpl = get_option('aialttext_token_prompt_template', 'Describe the image using the following context. Title: {title}. Context: {context}. Return only the alt text.');
$woo = get_option('aialttext_token_woocommerce_integration', 1);
$seo = get_option('aialttext_token_seo_integration', 1);
$hide_usage = get_option('aialttext_token_hide_usage_panel', 0);

// NEW: provide dropdown value & options
$output_language = get_option(
    'aialttext_token_output_language',
    function_exists('aialttext_token_guess_default_language') ? aialttext_token_guess_default_language() : 'English'
);
$lang_options = function_exists('aialttext_token_get_language_options') ? aialttext_token_get_language_options() : array('English' => 'English');
    
    ?>
    <div class="wrap aialttext-token-wrap">
    <h1><?php echo esc_html__('AI Alt Text Generator - Settings', 'aialttext-token'); ?></h1>
        <div class="aialttext-token-card">
            <form method="post">
                <?php wp_nonce_field('aialttext_token_save'); ?>
                <table class="form-table">
                <tr>
                <th><?php esc_html_e('Auto-generate on upload', 'aialttext-token'); ?></th>
<label>
  <input type="checkbox" name="auto_generate" value="1" <?php checked($auto, 1); ?> />
  <?php esc_html_e('Enable automatic alt text generation when images are uploaded', 'aialttext-token'); ?>
</label>
<p class="description" style="opacity:.8;">
  <?php
  echo wp_kses_post(
    __('Note: when enabled, automatic generation runs for <strong>all users who can upload files</strong> (e.g. Authors, Editors), regardless of the access levels configured below.', 'aialttext-token')
  );
  ?>
</p>
    </td>
</tr>
                    <tr>
                    <th><?php esc_html_e('Show indicators in Media Library', 'aialttext-token'); ?></th>
<label>
  <input type="checkbox" name="show_indicators" value="1" <?php checked($ind, 1); ?> />
  <?php esc_html_e('Show visual indicators for images with/without alt text', 'aialttext-token'); ?>
</label>
                        </td>
                    </tr>
                    <tr>
                    <th><?php esc_html_e('WooCommerce Integration', 'aialttext-token'); ?></th>
                        <td>
                            <label>
                                <input type="checkbox" name="woocommerce_integration" value="1" <?php checked($woo, 1); ?> /> 
                                <?php esc_html_e('Include product information in alt text generation', 'aialttext-token'); ?>
                            </label>
                        </td>
                    </tr>
                    <tr>
                    <th><?php esc_html_e('SEO Integration', 'aialttext-token'); ?></th>
                        <td>
                            <label>
                                <input type="checkbox" name="seo_integration" value="1" <?php checked($seo, 1); ?> /> 
                                <?php esc_html_e('Include SEO keywords and meta descriptions in context', 'aialttext-token'); ?>
                            </label>
                        </td>
                    </tr>
                    <tr>
                    <th><?php esc_html_e('Hide Token Balance Panel', 'aialttext-token'); ?></th>
                        <td>
                            <label>
                                <input type="checkbox" name="hide_usage_panel" value="1" <?php checked($hide_usage, 1); ?> /> 
                                Hide the token usage panel in the bulk processing tool
                            </label>
                        </td>
                    </tr>
                    <tr>
                    <th><?php esc_html_e('Images per request', 'aialttext-token'); ?></th>
    <td>
        <input type="number" value="1" disabled readonly class="small-text" />
        <em><?php esc_html_e('Fixed at 1 for reliability on larger libraries.', 'aialttext-token'); ?></em>
        <!-- Keep a hidden field so existing save logic and nonce flow remain intact -->
        <input type="hidden" name="batch_size" value="1" />
    </td>
</tr>
                   <!-- <tr>
                        <th>Max images per session</th>
                        <td>
                            <input type="number" min="0" name="max_images" value="<?php echo esc_attr($max); ?>" /> 
                            <em>0 = unlimited</em>
                        </td>
                    </tr> -->

                    <tr>
    <th><?php esc_html_e('Default output language', 'aialttext-token'); ?></th>
    <td>
        <select name="output_language" style="min-width:260px;">
            <?php foreach ($lang_options as $label => $label2): ?>
                <option value="<?php echo esc_attr($label); ?>" <?php selected($output_language, $label); ?>>
                    <?php echo esc_html($label); ?>
                </option>
            <?php endforeach; ?>
        </select>
        <p class="description">
            <?php esc_html_e('The AI will return a single-sentence ALT text in this language. Defaults to your site language when not set.', 'aialttext-token'); ?>
        </p>
    </td>
</tr>
                

                    <!--
                    <tr>
    <th>Prompt template</th>
    <td>
        <textarea name="prompt_template" rows="4" class="large-text"><?php echo esc_textarea($tmpl); ?></textarea>
        <p class="description">Variables: {title}, {context}</p>
    </td>
</tr>
-->

<tr>
    <th><?php esc_html_e('Role Access', 'aialttext-token'); ?></th>
    <td>
        <?php
        $roles  = function_exists('get_editable_roles') ? get_editable_roles() : array();
        $levels = aialttext_token_get_access_levels();
        $map    = aialttext_token_get_role_access_map();
        ?>
        <div class="aialttext-token-access">
            <p class="description" style="margin-top:0;">
            <p><?php esc_html_e('Choose what each role can do inside IMG Alt Gen Pro.', 'aialttext-token'); ?></p>
<p><?php esc_html_e('Full: Includes Account & Settings.', 'aialttext-token'); ?></p>
<p><?php esc_html_e('Partial: Adds Bulk Processing.', 'aialttext-token'); ?></p>
                Generate Only: shows per-image buttons but no Bulk/Settings.
            </p>
            <table class="wp-list-table widefat fixed striped aialttext-access-table" style="margin-top:12px;">
                <thead>
                    <tr>
                        <th style="width:40%;">Role</th>
                        <th>Access</th>
                    </tr>
                </thead>
                <tbody>
                <?php foreach ($roles as $role_key => $role_info): 
                    $label = isset($role_info['name']) ? $role_info['name'] : $role_key;
                    $current = isset($map[$role_key]) ? $map[$role_key] : 'none';
                ?>
                    <tr>
                        <td><strong><?php echo esc_html($label); ?></strong> <code style="opacity:.7;"><?php echo esc_html($role_key); ?></code></td>
                        <td>
                            <select name="aialttext_token_role_access[<?php echo esc_attr($role_key); ?>]" style="min-width:220px;">
                                <?php foreach ($levels as $val => $text): ?>
                                    <option value="<?php echo esc_attr($val); ?>" <?php selected($current, $val); ?>>
                                        <?php echo esc_html($text); ?>
                                    </option>
                                <?php endforeach; ?>
                            </select>
                        </td>
                    </tr>
                <?php endforeach; ?>
                </tbody>
            </table>
        </div>
    </td>
</tr>
                
                </table>
                <p>
                    <button class="button button-primary">Save Settings</button>
                    <input type="hidden" name="aialttext_token_save" value="1" />
                </p>
            </form>
        </div>
    </div>
    <?php
}

function aialttext_token_process_page(){
    if (!aialttext_token_user_can('bulk')) return;
    
    // Get current token balance
    $current_balance = aialttext_token_check_balance();
    
    ?>
    <div class="wrap aialttext-token-wrap">
    <h1>IMG Alt Gen Pro</h1>
<style>
/* Token thresholds */
.aialttext-tokens-remaining.aialttext-warn   { color:#d97706; } /* orange */
.aialttext-tokens-remaining.aialttext-danger { color:#b91c1c; } /* red */

/* Keep the preview cards’ vibe, just add a line for alt text */
.aialttext-images-grid .aialttext-image-item .aialttext-image-alt{
  margin-top:6px; font-size:12px; line-height:1.4; color:#ffffff;
  word-break:break-word;
}

/* Gentle sticky banner shown during processing */
.aialttext-processing-banner{
  position:sticky; top:32px; z-index:10;
  background:#fff8e6; border-left:4px solid #f59e0b; padding:10px 14px;
  margin:10px 0 0; border-radius:6px; color:#111111;
}
/* Success state once everything is done */
.aialttext-processing-banner.is-complete{
  background:#ecfdf5;             /* soft green */
  border-left-color:#10b981;       /* emerald */
  color:#111111;
  
}
</style>
        
        <div class="aialttext-modern-interface">
            <!-- Left Panel: Batch Processing -->
            <div class="aialttext-batch-panel">

                <h2>Batch Processing</h2>
<div id="aialttext_processing_banner" class="aialttext-processing-banner" style="display:none;">
<strong><?php esc_html_e('Working…', 'aialttext-token'); ?></strong>
<?php esc_html_e('Please keep this page open while images are being processed.', 'aialttext-token'); ?>
</div>
                <div class="aialttext-progress-section">
                    <div class="aialttext-progress-header">
                    <span class="aialttext-progress-label" id="aialttext_progress_label">
                    <?php esc_html_e('Scan to find images without alt text', 'aialttext-token'); ?>
</span>

<!-- keep these counters in the DOM (hidden) so existing JS that updates them
     continues to run harmlessly; they’re not used for display anymore -->
<span id="aialttext_token_processed_count" class="screen-reader-text" aria-hidden="true">0</span>
<span id="aialttext_token_total_images" class="screen-reader-text" aria-hidden="true">0</span>
                        <span class="aialttext-progress-indicator active" id="aialttext_progress_indicator">●</span>
                    </div>
                    
                    <div id="aialttext_token_progress_bar" class="aialttext-modern-progress-bar">
                        <div id="aialttext_token_progress" class="aialttext-modern-progress"></div>
                    </div>
                    
                    <div class="aialttext-controls">
                    <button class="button button-primary aialttext-scan-btn" id="aialttext_token_process_button">
  <?php esc_html_e('Scan Images', 'aialttext-token'); ?>
</button>
    <button class="button button-secondary aialttext-stop-btn" id="aialttext_token_stop_button" style="display:none;">Stop Processing</button>
</div>

<!-- NEW: optional per-run limit -->
<div class="aialttext-limit">
    <label for="aialttext_token_limit" class="screen-reader-text">How many images to process</label>
    <input
        type="number"
        id="aialttext_token_limit"
        class="aialttext-limit-input"
        min="1"
        step="1"
        placeholder="All available"
        aria-describedby="aialttext_limit_hint"
    />
    <div id="aialttext_limit_hint" class="aialttext-limit-hint">
        Leave empty to process all available images.
    </div>
</div>
                </div>
            </div>
            
            <!-- Right Panel: Token Usage -->
            <div class="aialttext-token-panel" id="aialttext_token_usage_panel" <?php if(get_option('aialttext_token_hide_usage_panel', 0)) echo 'style="display:none;"'; ?>>
                <h2>Token Usage</h2>
                <div class="aialttext-token-display">
                    <div class="aialttext-token-amount">
                        <span class="aialttext-tokens-used" id="aialttext_tokens_used">0</span>
                        <span class="aialttext-token-separator">/</span>
                        <span class="aialttext-tokens-remaining" id="aialttext_tokens_remaining"><?php echo esc_html($current_balance); ?></span>
                    </div>
                    <div class="aialttext-token-label">
                        <span class="aialttext-token-used-label">Images Processed</span> / <span class="aialttext-token-remaining-label">Tokens Remaining</span>
                    </div>
                    <a href="<?php echo admin_url('admin.php?page=aialttext-token'); ?>" class="aialttext-manage-tokens">Manage tokens →</a>
                </div>
            </div>
            
            <!-- Bottom Panel: Latest Images -->
<div class="aialttext-images-panel" id="aialttext_token_latest_images" style="display:none;">
    <div class="aialttext-images-grid" id="aialttext_images_grid"></div>

    <!-- New: controls for paginating processed thumbnails -->
    <div class="aialttext-images-controls" id="aialttext_images_controls" style="display:none;">
    <button type="button" class="button button-secondary aialttext-ctrl" id="aialttext_show_more" style="display:none;">Show more</button>
    <button type="button" class="button button-secondary aialttext-ctrl" id="aialttext_show_all"  style="display:none;">Show all processed</button>
</div>
</div>
        </div>
        
        <!-- Status and Error Messages -->
        <div id="aialttext_token_process_status" class="aialttext-token-process-status" style="margin-top: 20px;"></div>
        <div id="aialttext_token_error_details" class="aialttext-token-error-details"></div>
        
        <!-- Hidden legacy containers for compatibility -->
        <div style="display: none;">
            <span id="aialttext_token_error_count">0</span>
            <span id="aialttext_token_time_remaining">Unknown</span>
        </div>
    </div>
    <?php
}

function aialttext_token_help_page(){
    ?>
    <div class="wrap aialttext-token-wrap aialttext-dark">
    <h1><?php echo esc_html__('AI Alt Text Generator – Help & Documentation', 'aialttext-token'); ?></h1>

        <!-- Debug/Test Section 
        <div class="aialttext-token-card">
            <h2>🔧 Debug & Test Context Detection</h2>
            <p>Use this tool to test if SEO and WooCommerce context detection is working properly.</p>
            
            <div style="display: grid; grid-template-columns: 1fr 1fr; gap: 20px; margin: 20px 0;">
                <div>
                    <label for="test-post-id"><strong>Post/Product ID to Test:</strong></label><br>
                    <input type="number" id="test-post-id" placeholder="Enter post/product ID" style="width: 100%; margin: 5px 0;">
                    <button type="button" id="test-context-btn" class="button button-primary">Test Context Detection</button>
                </div>
                <div>
                    <label><strong>Test Results:</strong></label>
                    <div id="test-results" style="background: #f9f9f9; padding: 10px; border-radius: 4px; font-family: monospace; font-size: 12px; height: 200px; overflow: auto;">Click "Test Context Detection" to see results...</div>
                </div>
            </div>
            
            <script>
            jQuery(document).ready(function($) {
                $('#test-context-btn').click(function() {
                    var postId = $('#test-post-id').val();
                    if (!postId) {
                        alert('Please enter a post/product ID');
                        return;
                    }
                    
                    $('#test-results').text('Testing...');
                    
                    $.ajax({
                        url: ajaxurl,
                        type: 'POST',
                        data: {
                            action: 'aialttext_token_test_context',
                            post_id: postId,
                            nonce: '<?php echo wp_create_nonce('aialttext_token_nonce'); ?>'
                        },
                        success: function(response) {
                            if (response.success) {
                                var html = '';
                                html += '=== POST DETAILS ===\n';
                                html += 'ID: ' + response.data.post_details.ID + '\n';
                                html += 'Type: ' + response.data.post_details.post_type + '\n';
                                html += 'Title: ' + response.data.post_details.post_title + '\n\n';
                                
                                html += '=== SETTINGS ===\n';
                                html += 'WooCommerce Integration: ' + (response.data.settings.woocommerce_integration ? 'Enabled' : 'Disabled') + '\n';
                                html += 'SEO Integration: ' + (response.data.settings.seo_integration ? 'Enabled' : 'Disabled') + '\n';
                                html += 'Auto Generate: ' + (response.data.settings.auto_generate ? 'Enabled' : 'Disabled') + '\n';
                                html += 'WooCommerce Active: ' + (response.data.settings.woocommerce_active ? 'Yes' : 'No') + '\n';
                                html += 'Yoast Active: ' + (response.data.settings.yoast_active ? 'Yes' : 'No') + '\n';
                                if (response.data.yoast_focus_keyphrase !== undefined) {
                                    html += 'Yoast Focus Keyphrase: ' + (response.data.yoast_focus_keyphrase || 'None set') + '\n';
                                }
                                html += '\n';
                                
                                if (response.data.post_context) {
                                    html += '=== FULL CONTEXT (What AI receives) ===\n';
                                    html += response.data.post_context + '\n\n';
                                }
                                
                                if (response.data.woo_context) {
                                    html += '=== WOOCOMMERCE CONTEXT ===\n';
                                    html += response.data.woo_context + '\n\n';
                                }
                                
                                if (response.data.seo_context) {
                                    html += '=== SEO CONTEXT ===\n';
                                    html += response.data.seo_context + '\n\n';
                                }
                                
                                if (!response.data.post_context && !response.data.woo_context && !response.data.seo_context) {
                                    html += '⚠️ NO CONTEXT DETECTED!\n';
                                    html += 'This means context detection is not working properly.\n';
                                }
                                
                                $('#test-results').text(html);
                            } else {
                                $('#test-results').text('Error: ' + (response.data ? response.data.message : 'Unknown error'));
                            }
                        },
                        error: function() {
                            $('#test-results').text('AJAX Error: Could not connect to server');
                        }
                    });
                });
            });
            </script>
        </div> -->

        <div class="aialttext-token-card">
            <h2>Help & Documentation</h2>

            <div class="aialttext-token-help-section">
                <h3>Quick Start</h3>
                <ol>
                    <li>
                        Open
                        <a href="<?php echo esc_url( admin_url('admin.php?page=aialttext-token') ); ?>">
                            Account &amp; Tokens
                        </a>
                        and link your account (enter your email, then click <em>Link / Relink</em>).
                        New accounts receive <strong>10 free tokens</strong>.
                    </li>
                    <li>
                        Visit
                        <a href="<?php echo esc_url( admin_url('admin.php?page=aialttext-token-settings') ); ?>">
                            Settings
                        </a>
                        to configure:
                        <ul>
                            <li><strong>Auto-generate on upload</strong></li>
                            <li><strong>WooCommerce &amp; SEO integrations</strong> (Yoast focus keyphrase support)</li>
                            <li><strong>Prompt template</strong>, <strong>batch size</strong> and <strong>run cap</strong></li>
                            <li><strong>Visual indicators</strong> in the Media Library</li>
                            <li><strong>Role-based access</strong> (Full / Bulk / Generate / None)</li>
                        </ul>
                    </li>
                    <li>
                        Go to
                        <a href="<?php echo esc_url( admin_url('admin.php?page=aialttext-token-process') ); ?>">
                            Bulk Process Images
                        </a>
                        to generate alt text for images that are missing it.
                    </li>
                </ol>
            </div>

            <div class="aialttext-token-help-section">
                <h3>Using the Features</h3>
                <ul>
                    <li><strong>Automatic generation:</strong> When enabled, uploaded images are queued. Existing alt text is never overwritten.</li>
                    <li><strong>Bulk processing:</strong> The Bulk page lists images without alt text. Use the optional limit to cap a run; token usage updates live.</li>
                    <li><strong>Media Library indicators:</strong> Dots show status (green = has alt text, gray = missing). Each image has a <em>Generate Alt Text</em> action.</li>
                    <li><strong>Gutenberg:</strong> Select an Image block and click <em>Generate Alt Text</em> in the block toolbar/panel.</li>
                    <li><strong>WooCommerce:</strong> Product images automatically use product title, attributes, and short description for context.</li>
                    <li><strong>SEO context:</strong> If Yoast is active, the focus keyphrase and meta description are included in the prompt.</li>
                    <li><strong>Prompt template:</strong> Customize output style in Settings. Variables include post/product/SEO context.</li>
                    <li><strong>Permissions:</strong> Assign per-role access:
                        <em>Full</em> (all pages),
                        <em>Bulk</em>,
                        <em>Generate</em> (single-image only),
                        or <em>None</em>.
                    </li>
                </ul>
            </div>

            <div class="aialttext-token-help-section">
                <h3>Token System</h3>
                <ul>
                    <li><strong>1 token = 1 image</strong> processed.</li>
                    <li>Manage tokens from
                        <a href="<?php echo esc_url( admin_url('admin.php?page=aialttext-token') ); ?>">
                            Account &amp; Tokens
                        </a>.
                        Purchased bundles activate instantly.
                    </li>
                    <li>If tokens run out, processing pauses until more are added.</li>
                </ul>
            </div>

            <div class="aialttext-token-help-section">
                <h3>FAQ</h3>

                <div class="aialttext-token-faq">
                    <h4>Will existing alt text be changed?</h4>
                    <div class="aialttext-token-faq-answer">
                        <p>No. Only images without alt text are processed.</p>
                    </div>
                </div>

                <div class="aialttext-token-faq">
                    <h4>Can I generate alt text for a single image?</h4>
                    <div class="aialttext-token-faq-answer">
                        <p>Yes. Use the Media Library’s <em>Generate Alt Text</em> action or the Image block button in Gutenberg.</p>
                    </div>
                </div>

                <div class="aialttext-token-faq">
                    <h4>What data leaves my site?</h4>
                    <div class="aialttext-token-faq-answer">
                        <p>Only minimal context (title, captions, SEO fields) and the information required for analysis. Processing is secure and transient; only alt text returns to your site.</p>
                    </div>
                </div>

                <div class="aialttext-token-faq">
                    <h4>Can I see what images have been processed?</h4>
                    <div class="aialttext-token-faq-answer">
                        <p>Of course, you can view all usage history in the account and tokens page.</p>
                    </div>
                </div>
            </div>

            <div class="aialttext-token-help-section">
                <h3>Support</h3>
                <ul>
                    <li>Email: <a href="mailto:contact@arcticfoxdevelopments.com">contact@arcticfoxdevelopments.com</a></li>
                    <li>Documentation: <a href="https://imgaltgen.com/docs" target="_blank" rel="noopener">https://imgaltgen.com/docs</a></li>
                </ul>
            </div>
        </div>
    </div>
    <?php
}
        
        


// Ajax: account UI
add_action('wp_ajax_aialttext_token_link_account', 'aialttext_token_link_account');
add_action('wp_ajax_aialttext_token_refresh_balance', 'aialttext_token_refresh_balance');
add_action('wp_ajax_aialttext_token_get_pricing', 'aialttext_token_get_pricing');
add_action('wp_ajax_aialttext_token_purchase_tokens', 'aialttext_token_purchase_tokens');
add_action('wp_ajax_aialttext_token_confirm_payment', 'aialttext_token_confirm_payment');
add_action('wp_ajax_aialttext_token_load_usage', 'aialttext_token_load_usage');

// Map external image URLs to local Media Library items (1 batch request)
add_action('wp_ajax_aialttext_token_map_urls_to_media', 'aialttext_token_map_urls_to_media');
function aialttext_token_map_urls_to_media() {
    aialttext_token_check_nonce();
    if ( ! current_user_can('upload_files') ) {
        wp_send_json_error( array('message' => 'Insufficient privileges'), 403 );
    }

    $urls = isset($_POST['urls']) ? (array) $_POST['urls'] : array();
    $urls = array_filter(array_map('esc_url_raw', $urls));
    $map  = array();

    foreach ($urls as $u) {
        $id = attachment_url_to_postid($u);
        if ($id) {
            $map[$u] = array(
                'id'        => $id,
                'edit_link' => get_edit_post_link($id, 'raw'),
                'thumb'     => wp_get_attachment_image_url($id, 'thumbnail'),
            );
        } else {
            $map[$u] = null;
        }
    }

    if (defined('AIALTTEXT_ACCOUNT_DEBUG') && AIALTTEXT_ACCOUNT_DEBUG && function_exists('error_log')) {
        error_log('[AI Alt Text] URL->Media map: ' . wp_json_encode(array_keys($map)));
    }
    wp_send_json_success( array('map' => $map) );
}

// Ajax: processing
add_action('wp_ajax_aialttext_token_list_missing', 'aialttext_token_list_missing');

function aialttext_token_check_nonce(){ 
    if (!wp_verify_nonce(isset($_POST['nonce']) ? $_POST['nonce'] : '', 'aialttext_token_nonce')) {
        wp_send_json_error(array('message' => 'Security check failed')); 
    }
}

function aialttext_token_link_account(){
    aialttext_token_check_nonce();
    if ( ! aialttext_token_user_can('account') ) {
        wp_send_json_error(array('message' => 'Insufficient privileges'), 403);
    }
    $email = sanitize_email($_POST['email'] ?? '');
    if (!$email) wp_send_json_error(array('message' => 'Email required'));
    
    update_option('aialttext_token_account_email', $email);
    $api = new AiAltText_Token_API_Client();
    $result = $api->link_account($email, parse_url(get_site_url(), PHP_URL_HOST));
    
    if (!empty($result['success'])){
        if (!empty($result['access_key'])) {
            update_option('aialttext_token_access_key', $result['access_key']);
        }
        wp_send_json_success(array(
            'message' => isset($result['message']) ? $result['message'] : 'Linked',
            'balance' => isset($result['token_balance']) ? $result['token_balance'] : 0
        ));
    }
    
    wp_send_json_error(array('message' => isset($result['error']['message']) ? $result['error']['message'] : 'Failed to link'));
}

function aialttext_token_refresh_balance(){
    aialttext_token_check_nonce();
    if ( ! aialttext_token_user_can('account') ) {
        wp_send_json_error(array('message' => 'Insufficient privileges'), 403);
    }
    $api = new AiAltText_Token_API_Client(); 
    $result = $api->status();
    
    if (!empty($result['success'])) {
        wp_send_json_success(array('balance' => $result['token_balance']));
    }
    
    wp_send_json_error(array('message' => isset($result['error']['message']) ? $result['error']['message'] : 'Unable to fetch balance'));
}

function aialttext_token_get_pricing(){ 
    aialttext_token_check_nonce(); 
    if ( ! aialttext_token_user_can('account') ) {
        wp_send_json_error(array('message' => 'Insufficient privileges'), 403);
    }
    $result = aialttext_token_cached_pricing(); 
    
    if (!empty($result['success'])) {
        wp_send_json_success($result); 
    }
    
    wp_send_json_error(array('message' => isset($result['error']['message']) ? $result['error']['message'] : 'Pricing not available')); 
}

function aialttext_token_purchase_tokens(){
    aialttext_token_check_nonce();
    if ( ! aialttext_token_user_can('account') ) {
        wp_send_json_error(array('message' => 'Insufficient privileges'), 403);
    }
    $pkg = sanitize_text_field(isset($_POST['package_id']) ? $_POST['package_id'] : '');
    if (!$pkg) wp_send_json_error(array('message' => 'Missing package'));
    
    $base = admin_url('admin.php?page=aialttext-token');
    $success = $base . (strpos($base, '?') !== false ? '&' : '?') . 'payment=success&session_id={CHECKOUT_SESSION_ID}';
    $cancel = $base . (strpos($base, '?') !== false ? '&' : '?') . 'payment=cancelled';
    
    $api = new AiAltText_Token_API_Client();
    $result = $api->purchase($pkg, $success, $cancel, parse_url(get_site_url(), PHP_URL_HOST));
    
    if (!empty($result['success']) && !empty($result['checkout_url'])) {
        wp_send_json_success(array(
            'checkout_url' => $result['checkout_url'],
            'session_id' => $result['session_id']
        ));
    }
    
    wp_send_json_error(array('message' => isset($result['error']['message']) ? $result['error']['message'] : 'Payment could not be initiated'));
}
function aialttext_token_confirm_payment(){
    aialttext_token_check_nonce();
    if ( ! aialttext_token_user_can('account') ) {
        wp_send_json_error(array('message' => 'Insufficient privileges'), 403);
    }
    $session_id = sanitize_text_field(isset($_POST['session_id']) ? $_POST['session_id'] : '');
    if (!$session_id) wp_send_json_error(array('message' => 'Missing session_id'));
    
    $api = new AiAltText_Token_API_Client();
    $result = $api->confirm($session_id);
    
    if (!empty($result['success'])){
        $status_result = $api->status();
        $balance = !empty($status_result['success']) ? (isset($status_result['token_balance']) ? $status_result['token_balance'] : null) : null;
        $added = isset($result['tokens_added']) ? intval($result['tokens_added']) : 0;
        $pkg = isset($result['package_tokens']) ? intval($result['package_tokens']) : $added;
        
        wp_send_json_success(array(
            'message' => ($added > 0 ? 'Payment confirmed. ' . $added . ' tokens added.' : 'Payment confirmed. ' . $pkg . ' tokens added.'),
            'tokens_added' => $added,
            'package_tokens' => $pkg,
            'balance' => $balance
        ));
    }
    
    wp_send_json_error(array('message' => isset($result['error']['message']) ? $result['error']['message'] : 'Payment confirmation failed'));
}

function aialttext_token_load_usage(){
    aialttext_token_check_nonce();
    if ( ! aialttext_token_user_can('account') ) {
        wp_send_json_error(array('message' => 'Insufficient privileges'), 403);
    }
    $api = new AiAltText_Token_API_Client();
    $result = $api->usage();
    
    if (!empty($result['success'])) {
        wp_send_json_success($result);
    }
    
    wp_send_json_error(array('message' => isset($result['error']['message']) ? $result['error']['message'] : 'Unable to load usage data'));
}

function aialttext_token_list_missing(){
    aialttext_token_check_nonce();
    if ( ! aialttext_token_user_can('bulk') ) {
        wp_send_json_error(array('message' => 'Insufficient privileges'), 403);
    }
    global $wpdb;
    
    $max = max(0, intval(get_option('aialttext_token_max_images', 0)));
    $limit_sql = $max > 0 ? $wpdb->prepare("LIMIT %d", $max) : "";
    
    $ids = $wpdb->get_col("
        SELECT p.ID
        FROM {$wpdb->posts} p
        LEFT JOIN {$wpdb->postmeta} m ON m.post_id=p.ID AND m.meta_key='_wp_attachment_image_alt'
        WHERE p.post_type='attachment' AND p.post_mime_type LIKE 'image/%'
        AND (m.meta_value IS NULL OR m.meta_value='')
        ORDER BY p.ID DESC
        $limit_sql
    ");
    
    wp_send_json_success(array('ids' => array_map('intval', $ids)));
}