<?php
if (!defined('ABSPATH')) exit;

class AiAltText_Token_API_Client {
    private $api_base; 
    private $access_key;
    
    public function __construct(){
        $this->api_base = defined('AIALTTEXT_TOKEN_API_BASE') ? AIALTTEXT_TOKEN_API_BASE : admin_url('admin-ajax.php');
        $this->access_key = trim(get_option('aialttext_token_access_key',''));
    }
    
    private function request($action, $method='POST', $data=array()){
        $args = array('method' => $method, 'timeout' => 25);
        $body = array_merge($data, array('action' => $action));
        
        if ($this->access_key) {
            $body['access_key'] = $this->access_key;
        }
        
        if ($method === 'GET') { 
            $url = add_query_arg($body, $this->api_base); 
        } else { 
            $url = $this->api_base; 
            $args['body'] = $body; 
        }
        
        $resp = wp_remote_request($url, $args);
        
        if (is_wp_error($resp)) {
            return array('success' => false, 'error' => array('message' => $resp->get_error_message()));
        }
        
        $code = wp_remote_retrieve_response_code($resp);
        $json = json_decode(wp_remote_retrieve_body($resp), true);
        
        if (!is_array($json)) {
            return array('success' => false, 'error' => array('message' => 'Invalid response ('.$code.')'));
        }
        
        return $json;
    }
    
    public function link_account($email, $domain) { 
        return $this->request('aialttext_account_link', 'POST', compact('email', 'domain')); 
    }
    
    public function status() { 
        return $this->request('aialttext_account_status', 'POST'); 
    }
    
    public function pricing() { 
        return $this->request('aialttext_account_pricing', 'GET'); 
    }
    
    public function purchase($package_id, $success_url, $cancel_url, $domain) { 
        return $this->request('aialttext_account_purchase', 'POST', compact('package_id', 'success_url', 'cancel_url', 'domain')); 
    }
    
    public function confirm($session_id) { 
        return $this->request('aialttext_confirm_payment', 'POST', compact('session_id')); 
    }
    
    public function generate($image_url, $image_title='', $context='') { 
        return $this->request('aialttext_account_generate', 'POST', compact('image_url', 'image_title', 'context')); 
    }
    
    public function usage() {
        return $this->request('aialttext_account_usage', 'POST');
    }
}

function aialttext_token_cached_pricing(){
    $cached = get_transient('aialttext_token_pricing'); 
    if ($cached) return $cached;
    
    $api = new AiAltText_Token_API_Client(); 
    $result = $api->pricing();
    
    if (!empty($result['success'])) {
        set_transient('aialttext_token_pricing', $result, 15 * MINUTE_IN_SECONDS);
    }
    
    return $result;
}

function aialttext_token_check_balance() {
    $api = new AiAltText_Token_API_Client();
    $result = $api->status();
    
    if (!empty($result['success'])) {
        return intval($result['token_balance'] ?? 0);
    }
    
    return 0;
}

function aialttext_token_has_sufficient_balance($required_tokens = 1) {
    $balance = aialttext_token_check_balance();
    return $balance >= $required_tokens;
}