<?php
// Syntax checker for the token plugin
echo "Checking PHP syntax for all files...\n\n";

$files = [
    'ai-alt-text-generator-free.php',
    'includes/api-client.php',
    'includes/image-processor.php',
    'includes/integrations.php', 
    'includes/admin-pages.php',
    'includes/settings-page.php'
];

foreach ($files as $file) {
    if (file_exists($file)) {
        echo "Checking $file... ";
        $output = [];
        $return_var = 0;
        exec("php -l " . escapeshellarg($file), $output, $return_var);
        
        if ($return_var === 0) {
            echo "✓ OK\n";
        } else {
            echo "✗ ERROR\n";
            echo implode("\n", $output) . "\n";
        }
    } else {
        echo "✗ File $file not found\n";
    }
}
echo "\nDone.\n";
?>